/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.annotations.RootNode;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.service.Version;
import org.gcube.common.storagehub.model.service.VersionList;
import org.gcube.common.storagehub.model.types.ACLList;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class DefaultItemManager
implements ItemManagerClient {
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGHT = "Content-Length";

    public DefaultItemManager(ProxyDelegate<GXWebTargetAdapterRequest> config) {
        this.delegate = config;
    }

    @Override
    public StreamDescriptor resolvePublicLink(final String identifier) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, StreamDescriptor> call = new Call<GXWebTargetAdapterRequest, StreamDescriptor>(){

            @Override
            public StreamDescriptor call(GXWebTargetAdapterRequest manager) throws StorageHubException, Exception {
                Objects.requireNonNull(identifier, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path("publiclink").path(identifier);
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                Response resp = response.getSource();
                return DefaultItemManager.this.createStreamDescriptor(resp);
            }
        };
        try {
            StreamDescriptor result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    @Deprecated
    public List<? extends Item> getChildren(String id, Class<? extends Item> onlyOfType, String ... excludeNodes) throws StorageHubException {
        return this.getChildren(id, onlyOfType, false, excludeNodes);
    }

    @Override
    public List<? extends Item> getChildren(final String id, final Class<? extends Item> onlyOfType, final boolean showHidden, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws StorageHubException, Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("children");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if (onlyOfType != null) {
                    params.put("onlyType", new Object[]{DefaultItemManager.this.resolveNodeType(onlyOfType)});
                }
                params.put("showHidden", new Object[]{showHidden});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemList items = response.getSource().readEntity(ItemList.class);
                return items;
            }
        };
        try {
            ItemList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> getChildren(final String id, final int start, final int limit, final boolean showHidden, final Class<? extends Item> onlyOfType, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                try {
                    GXWebTargetAdapterRequest myManager = manager.path(id).path("children").path("paged");
                    HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                    if (excludeNodes != null && excludeNodes.length > 0) {
                        params.put("exclude", excludeNodes);
                    }
                    if (onlyOfType != null) {
                        params.put("onlyType", new Object[]{DefaultItemManager.this.resolveNodeType(onlyOfType)});
                    }
                    params.put("start", new Object[]{start});
                    params.put("limit", new Object[]{limit});
                    params.put("showHidden", new Object[]{showHidden});
                    GXInboundResponse response = myManager.queryParams(params).get();
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                    }
                    ItemList items = response.getSource().readEntity(ItemList.class);
                    return items;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        };
        try {
            ItemList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> getChildren(String id, int start, int limit, boolean showHidden, String ... excludeNodes) throws StorageHubException {
        return this.getChildren(id, start, limit, showHidden, (Class<? extends Item>)null, excludeNodes);
    }

    @Override
    @Deprecated
    public List<? extends Item> getChildren(String id, String ... excludeNodes) throws StorageHubException {
        return this.getChildren(id, false, excludeNodes);
    }

    @Override
    public List<? extends Item> getChildren(String id, boolean showHidden, String ... excludeNodes) throws StorageHubException {
        return this.getChildren(id, null, showHidden, excludeNodes);
    }

    @Override
    public List<? extends Item> search(final String id, final Class<? extends Item> onlyOfType, final boolean showHidden, final boolean excludeTrashed, final String nameToMatch, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws StorageHubException, Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("search");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if (onlyOfType != null) {
                    params.put("onlyType", new Object[]{DefaultItemManager.this.resolveNodeType(onlyOfType)});
                }
                params.put("showHidden", new Object[]{showHidden});
                params.put("name", new String[]{URLEncoder.encode(nameToMatch, "UTF-8")});
                params.put("excludeTrashed", new Object[]{excludeTrashed});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemList items = response.getSource().readEntity(ItemList.class);
                return items;
            }
        };
        try {
            ItemList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    @Deprecated
    public Integer childrenCount(String id, Class<? extends Item> onlyOfType) throws StorageHubException {
        return this.childrenCount(id, false, onlyOfType);
    }

    @Override
    public Integer childrenCount(final String id, final boolean showHidden, final Class<? extends Item> onlyOfType) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Integer> call = new Call<GXWebTargetAdapterRequest, Integer>(){

            @Override
            public Integer call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("children").path("count");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (onlyOfType != null) {
                    params.put("onlyType", new Object[]{DefaultItemManager.this.resolveNodeType(onlyOfType)});
                }
                params.put("showHidden", new Object[]{showHidden});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(Integer.class);
            }
        };
        try {
            Integer result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    @Deprecated
    public Integer childrenCount(String id) throws StorageHubException {
        return this.childrenCount(id, false);
    }

    @Override
    public Integer childrenCount(String id, boolean showHidden) throws StorageHubException {
        return this.childrenCount(id, showHidden, null);
    }

    private String resolveNodeType(Class<? extends Item> itemClass) throws StorageHubException {
        if (!itemClass.isAnnotationPresent(RootNode.class)) {
            return null;
        }
        String nodeType = itemClass.getAnnotation(RootNode.class).value();
        return nodeType;
    }

    @Override
    public StreamDescriptor download(final String id, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, StreamDescriptor> call = new Call<GXWebTargetAdapterRequest, StreamDescriptor>(){

            @Override
            public StreamDescriptor call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("download");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                Response resp = response.getSource();
                return DefaultItemManager.this.createStreamDescriptor(resp);
            }
        };
        try {
            StreamDescriptor result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public StreamDescriptor downloadSpecificVersion(final String id, final String version) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, StreamDescriptor> call = new Call<GXWebTargetAdapterRequest, StreamDescriptor>(){

            @Override
            public StreamDescriptor call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(version, "version cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("versions").path(version).path("download");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                Response resp = response.getSource();
                return DefaultItemManager.this.createStreamDescriptor(resp);
            }
        };
        try {
            StreamDescriptor result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<Version> getFileVersions(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, VersionList> call = new Call<GXWebTargetAdapterRequest, VersionList>(){

            @Override
            public VersionList call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("versions");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                VersionList versions = response.getSource().readEntity(VersionList.class);
                return versions;
            }
        };
        try {
            VersionList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public Item get(final String id, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemWrapper<Item>> call = new Call<GXWebTargetAdapterRequest, ItemWrapper<Item>>(){

            @Override
            public ItemWrapper<Item> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id);
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemWrapper item = response.getSource().readEntity(ItemWrapper.class);
                return item;
            }
        };
        try {
            ItemWrapper<Item> result = this.delegate.make(call);
            return result.getItem();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public Item getByRelativePath(final String id, final String path, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemWrapper<Item>> call = new Call<GXWebTargetAdapterRequest, ItemWrapper<Item>>(){

            @Override
            public ItemWrapper<Item> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(path, "path cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("path");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                params.put("path", new String[]{path});
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemWrapper item = response.getSource().readEntity(ItemWrapper.class);
                return item;
            }
        };
        try {
            ItemWrapper<Item> result = this.delegate.make(call);
            return result.getItem();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public Item getRootSharedFolder(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemWrapper<Item>> call = new Call<GXWebTargetAdapterRequest, ItemWrapper<Item>>(){

            @Override
            public ItemWrapper<Item> call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("rootSharedFolder");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemWrapper item = response.getSource().readEntity(ItemWrapper.class);
                return item;
            }
        };
        try {
            ItemWrapper<Item> result = this.delegate.make(call);
            return result.getItem();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public URL getPublickLink(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, URL> call = new Call<GXWebTargetAdapterRequest, URL>(){

            @Override
            public URL call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("publiclink");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                URL item = response.getSource().readEntity(URL.class);
                return item;
            }
        };
        try {
            URL result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public URL getPublickLink(final String id, final String version) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, URL> call = new Call<GXWebTargetAdapterRequest, URL>(){

            @Override
            public URL call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(version, "version cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("publiclink");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                params.put("version", new Object[]{version});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                URL item = response.getSource().readEntity(URL.class);
                return item;
            }
        };
        try {
            URL result = this.delegate.make(call);
            return result;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> findChildrenByNamePattern(final String id, final String name, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(id, "name cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("items").path(name);
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                ItemList items = response.getSource().readEntity(ItemList.class);
                return items;
            }
        };
        try {
            ItemList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String uploadFile(final InputStream stream, final String parentId, final String fileName, final String description) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(stream, "stream cannot be null");
                Objects.requireNonNull(parentId, "parentId cannot be null");
                Objects.requireNonNull(fileName, "parentId cannot be null");
                Objects.requireNonNull(description, "parentId cannot be null");
                GXWebTargetAdapterRequest myManager = manager.register(MultiPartFeature.class).path(parentId).path("create").path("FILE");
                GXInboundResponse response = null;
                FormDataMultiPart multipart = new FormDataMultiPart();
                multipart.field("name", fileName);
                multipart.field("description", description);
                multipart.field("file", stream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                Entity<FormDataMultiPart> entity = Entity.entity(multipart, "multipart/form-data");
                response = myManager.post(entity);
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String uploadArchive(final InputStream stream, final String parentId, final String extractionFolderName) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(stream, "stream cannot be null");
                Objects.requireNonNull(parentId, "parentId cannot be null");
                Objects.requireNonNull(extractionFolderName, "extraction folder name cannot be null");
                GXWebTargetAdapterRequest myManager = manager.register(MultiPartFeature.class).path(parentId).path("create").path("ARCHIVE");
                FormDataMultiPart multipart = new FormDataMultiPart();
                multipart.field("parentFolderName", extractionFolderName);
                multipart.field("file", stream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                GXInboundResponse response = myManager.post(Entity.entity(multipart, MediaType.MULTIPART_FORM_DATA_TYPE));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    @Deprecated
    public String createFolder(final String parentId, final String name, final String description) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                return DefaultItemManager.this.createFolder(parentId, name, description, false);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String createFolder(final String parentId, final String name, final String description, final boolean hidden) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(parentId, "parentId cannot be null");
                Objects.requireNonNull(name, "folder name cannot be null");
                Objects.requireNonNull(description, "parentId cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(parentId).path("create").path("FOLDER");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("name", name);
                formData.add("description", description);
                formData.add("hidden", Boolean.toString(hidden));
                GXInboundResponse response = myManager.post(Entity.entity(formData, "application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String createURL(final String parentId, final String name, final String description, final URL url) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(parentId, "parentId cannot be null");
                Objects.requireNonNull(name, "folder name cannot be null");
                Objects.requireNonNull(description, "parentId cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(parentId).path("create").path("URL");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("name", name);
                formData.add("description", description);
                formData.add("value", url.toString());
                GXInboundResponse response = myManager.post(Entity.entity(formData, "application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String createGcubeItem(final String parentId, final GCubeItem item) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(parentId, "parentId cannot be null");
                Objects.requireNonNull(item, "item cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(parentId).path("create").path("GCUBEITEM");
                GXInboundResponse response = myManager.post(Entity.json(item));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String shareFolder(final String id, final Set<String> users, final AccessType accessType) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(users, "users list cannot be null");
                Objects.requireNonNull(accessType, "access type cannot be null");
                GXWebTargetAdapterRequest myManager = manager.register(MultiPartFeature.class).path(id).path("share");
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    multipart.field("defaultAccessType", (Object)accessType, MediaType.APPLICATION_JSON_TYPE);
                    multipart.field("users", users, MediaType.APPLICATION_JSON_TYPE);
                    GXInboundResponse response = myManager.put(Entity.entity(multipart, MediaType.MULTIPART_FORM_DATA_TYPE));
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                    }
                    String string = response.getSource().readEntity(String.class);
                    return string;
                }
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String unshareFolder(final String id, final Set<String> users) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(users, "users list cannot be null");
                GXWebTargetAdapterRequest myManager = manager.register(MultiPartFeature.class).path(id).path("unshare");
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    multipart.field("users", users, MediaType.APPLICATION_JSON_TYPE);
                    GXInboundResponse response = myManager.put(Entity.entity(multipart, MediaType.MULTIPART_FORM_DATA_TYPE));
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                    }
                    String string = response.getSource().readEntity(String.class);
                    return string;
                }
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    @Deprecated
    public void delete(String id) throws StorageHubException {
        this.delete(id, false);
    }

    @Override
    public void delete(final String id, final boolean force) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                HashMap<String, Object[]> queryParam = new HashMap<String, Object[]>();
                queryParam.put("force", new Object[]{force});
                GXWebTargetAdapterRequest myManager = manager.path(id);
                GXInboundResponse response = myManager.queryParams(queryParam).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> getAnchestors(final String id, final String ... excludeNodes) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("anchestors");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            ItemList result = this.delegate.make(call);
            return result.getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<ACL> getACL(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ACLList> call = new Call<GXWebTargetAdapterRequest, ACLList>(){

            @Override
            public ACLList call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("acls");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(ACLList.class);
            }
        };
        try {
            return this.delegate.make(call).getAcls();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public boolean canWriteInto(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Boolean> call = new Call<GXWebTargetAdapterRequest, Boolean>(){

            @Override
            public Boolean call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("acls").path("write");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(Boolean.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String changeACL(final String id, final String user, final AccessType accessType) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(user, "user cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("acls");
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    multipart.field("access", (Object)accessType, MediaType.APPLICATION_JSON_TYPE);
                    multipart.field("user", user);
                    GXInboundResponse response = myManager.put(Entity.entity(multipart, MediaType.MULTIPART_FORM_DATA_TYPE));
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                    }
                    String string = response.getSource().readEntity(String.class);
                    return string;
                }
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String removeAdmin(final String id, final String user) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(user, "user cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("acls").path(user);
                GXInboundResponse response = myManager.delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String copy(final String id, final String destinationFolderId, final String newFilename) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(newFilename, "new file name cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("copy");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("destinationId", destinationFolderId);
                formData.add("fileName", newFilename);
                GXInboundResponse response = myManager.put(Entity.form(formData));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String setPublic(final String id, final boolean publish) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("publish");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("publish", Boolean.toString(publish));
                GXInboundResponse response = myManager.put(Entity.form(formData));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String move(final String id, final String destinationFolderId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(destinationFolderId, "destination folder cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("move");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("destinationId", destinationFolderId);
                GXInboundResponse response = myManager.put(Entity.form(formData));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String rename(final String id, final String newName) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(newName, "new name cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("rename");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                formData.add("newName", newName);
                GXInboundResponse response = myManager.put(Entity.form(formData));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String setHidden(final String id, final Boolean value) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(value, "value cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("hidden");
                GXInboundResponse response = myManager.put(Entity.json(value));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String setDescription(final String id, final String description) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(description, "description cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("description");
                GXInboundResponse response = myManager.put(Entity.json(description));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String setMetadata(final String id, final Metadata metadata) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                Objects.requireNonNull(metadata, "metadata cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id).path("metadata");
                GXInboundResponse response = myManager.put(Entity.json(metadata));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private StreamDescriptor createStreamDescriptor(Response resp) {
        InputStream stream = resp.readEntity(InputStream.class);
        String disposition = resp.getHeaderString(CONTENT_DISPOSITION);
        String fileName = disposition.replaceFirst("attachment; filename = ([^/s]+)?", "$1");
        String contentType = resp.getHeaderString(CONTENT_TYPE);
        long contentLenght = -1L;
        try {
            contentLenght = Long.parseLong(resp.getHeaderString(CONTENT_LENGHT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StreamDescriptor(stream, fileName, contentType, contentLenght);
    }
}

