package org.gcube.data.access.storagehub.fs;

import java.io.IOException;
import java.io.InputStream;

import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jnr.ffi.Pointer;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public class FileDownload implements SHFile{

	public static Logger logger = LoggerFactory.getLogger(FileDownload.class);

	InputStream stream;
	AbstractFileItem fileItem;
	
	public FileDownload(FileContainer fileContainer) throws Exception {
		stream = fileContainer.download().getStream();
		fileItem = fileContainer.get();
		logger.trace("FILE-DOWNLOAD initialized with {} , {}", fileItem.getName(), fileItem.getContent().getSize());
	}

	public synchronized int read(Pointer buf, @size_t long size, @off_t long offset) {
		logger.trace("read called with size {} and offset {} ", size, offset);
		
		int bytesToRead = (int) (size);

		byte[] mybuf = new byte[bytesToRead];
		int readTotal= 0;;	
		try {

			int read =0;
			while ((read= stream.read(mybuf, 0 , bytesToRead-readTotal))!=-1 && bytesToRead>readTotal) {
				buf.put(0, mybuf, 0, read);
				readTotal+= read;
			}

			logger.trace("bytes to read {} and read total {} and last read {}", bytesToRead, readTotal, read);
		}catch (Exception e) {
			logger.error("error in read",e);
			try {
				stream.close();
			} catch (IOException e1) {}
			return -ErrorCodes.ENOENT();
		}

		return readTotal;
	}
	
	
	

	public synchronized int flush() {
		logger.trace("called flush");
		//logger.trace("file is ready "+mapPathUpload.get(path).toString());
		try {
			stream.close();
		} catch (IOException e1) {
			logger.error("error closing stream",e1);
		}
		return 0;
	}	
	

	public int getAttr(FileStat stat) {
		logger.trace("is in download");
		stat.st_mode.set(FileStat.S_IFREG | 0555);
		stat.st_size.set(fileItem.getContent().getSize());
		stat.st_mtim.tv_sec.set(fileItem.getLastModificationTime().toInstant().getEpochSecond());
		stat.st_mtim.tv_nsec.set(fileItem.getLastModificationTime().toInstant().getNano());
		stat.st_ctim.tv_sec.set(fileItem.getCreationTime().toInstant().getEpochSecond());
		stat.st_ctim.tv_nsec.set(fileItem.getCreationTime().toInstant().getNano());
		stat.st_atim.tv_sec.set(fileItem.getLastModificationTime().toInstant().getEpochSecond());
		stat.st_atim.tv_nsec.set(fileItem.getLastModificationTime().toInstant().getNano());
		return 0;
	}
	
}
