/*
 * Decompiled with CFR 0.152.
 */
package ru.serce.jnrfuse.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import jnr.posix.util.Platform;
import ru.serce.jnrfuse.FuseException;

public class WinPathUtils {
    public static String getWinFspPath() {
        if (!Platform.IS_WINDOWS) {
            throw new FuseException("WinFsp can only be configured on Windows");
        }
        String configuredPath = System.getProperty("jnrfuse.winfsp.path");
        if (configuredPath != null && !configuredPath.isEmpty()) {
            if (!WinPathUtils.libExists(configuredPath)) {
                throw new FuseException("Configured winfsp library (jnrfuse.winfsp.path property) " + configuredPath + " can't be found");
            }
            return configuredPath;
        }
        String registryPath = WinPathUtils.extractRegLibraryPath();
        if (WinPathUtils.libExists(registryPath)) {
            return registryPath;
        }
        String defaultPath = "C:\\Program Files (x86)\\WinFsp\\bin\\winfsp-x64.dll";
        if (WinPathUtils.libExists(defaultPath)) {
            return defaultPath;
        }
        throw new FuseException("Can't find winfsp library. Please make sure that winfsp is installed or configure the path to dll manually using the `jnrfuse.winfsp.path` property");
    }

    private static String extractRegLibraryPath() {
        String regInstallRecord = WinPathUtils.extractRegInstallRecord();
        if (regInstallRecord == null) {
            return null;
        }
        String[] keyParts = regInstallRecord.split(" {4}");
        if (keyParts.length < 4) {
            return null;
        }
        String libraryPath = keyParts[3];
        if (!libraryPath.endsWith("\\")) {
            libraryPath = libraryPath + "\\";
        }
        return libraryPath + "bin\\winfsp-x64.dll";
    }

    private static String extractRegInstallRecord() {
        if (Platform.IS_64_BIT) {
            return WinPathUtils.getRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\WinFsp", "InstallDir");
        }
        return WinPathUtils.getRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\WinFsp", "InstallDir");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getRegistryKey(String path, String key) {
        String reqCmd = String.format("reg query %s /v %s", path, key);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(reqCmd).getInputStream()));){
            String string = br.lines().collect(Collectors.joining(""));
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean libExists(String path) {
        try {
            return path != null && !path.isEmpty() && Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }
}

