/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.tools;

import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class PointsMapCreator {
    private static String tempTableDrop = "drop table %1$s";
    private static String buildTempTable = "create table  %1$s (pointid serial);";
    private static String createPointsGeometriesColumn = "Select AddGeometryColumn('%1$s','the_geom',4326,'POINT',2)";
    private static String rawSelect = "select %1$s from %2$s limit %3$s offset %4$s";
    private static String rawInsert = "INSERT INTO %1$s (%2$s) VALUES %3$s";
    private String persistencePath;
    ConnectionsManager connectionsManager;

    public static void main(String[] args) {
    }

    public PointsMapCreator(TSGeoToolsConfiguration configuration) throws Exception {
        try {
            String configPath = configuration.getConfigPath();
            if (!configPath.endsWith("/")) {
                configPath = configPath + "/";
            }
            this.persistencePath = configuration.getPersistencePath() != null ? configuration.getPersistencePath() : configPath;
            if (!this.persistencePath.endsWith("/")) {
                this.persistencePath = this.persistencePath + "/";
            }
            AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
            AnalysisLogger.getLogger().trace((Object)"Create Points Map-> initializing connections");
            this.connectionsManager = new ConnectionsManager(configPath);
            EngineConfiguration tscfg = null;
            EngineConfiguration geocfg = null;
            if (configuration.getTimeSeriesDatabase() != null) {
                tscfg = new EngineConfiguration();
                tscfg.setConfigPath(configPath);
                tscfg.setDatabaseUserName(configuration.getTimeSeriesUserName());
                tscfg.setDatabasePassword(configuration.getTimeSeriesPassword());
                tscfg.setDatabaseURL(configuration.getTimeSeriesDatabase());
                AnalysisLogger.getLogger().trace((Object)"Create Points Map-> connected to Time Series");
                this.connectionsManager.initTimeSeriesConnection(tscfg);
            }
            if (configuration.getGeoServerDatabase() != null) {
                geocfg = new EngineConfiguration();
                geocfg.setConfigPath(configPath);
                geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
                geocfg.setDatabasePassword(configuration.getGeoServerPassword());
                geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
                AnalysisLogger.getLogger().trace((Object)"Create Points Map-> connected to Geo Server");
                this.connectionsManager.initGeoserverConnection(geocfg);
            }
        }
        catch (Exception e) {
            this.connectionsManager.shutdownAll();
            throw e;
        }
    }

    public GISInformation duplicateGISInformation(GISInformation gisInfo) {
        GISInformation localGISInfo = new GISInformation();
        localGISInfo.setGeoNetworkUrl(gisInfo.getGeoNetworkUrl());
        localGISInfo.setGeoNetworkUserName(gisInfo.getGeoNetworkUserName());
        localGISInfo.setGeoNetworkPwd(gisInfo.getGeoNetworkPwd());
        localGISInfo.setGisDataStore(gisInfo.getGisDataStore());
        localGISInfo.setGisPwd(gisInfo.getGisPwd());
        localGISInfo.setGisUrl(gisInfo.getGisUrl());
        localGISInfo.setGisUserName(gisInfo.getGisUserName());
        localGISInfo.setGisWorkspace(gisInfo.getGisWorkspace());
        return localGISInfo;
    }

    public String generateXYMapFromPoints(List<Tuple<Float>> xyPoints, String destinationTable, boolean createMap, String mapName, GISInformation gisInfo) throws Exception {
        GISInformation localGISInfo = this.duplicateGISInformation(gisInfo);
        int numberOfPoints = xyPoints.size();
        StringBuffer allInfo = new StringBuffer();
        for (int k = 0; k < numberOfPoints; ++k) {
            allInfo.append("(");
            Tuple<Float> couple = xyPoints.get(k);
            String x = "" + couple.getElements().get(0);
            String y = "" + couple.getElements().get(1);
            try {
                double xd = Double.parseDouble(x);
                double yd = Double.parseDouble(y);
                AnalysisLogger.getLogger().trace((Object)("---" + x + "," + y + "---"));
                allInfo.append("ST_SetSRID(ST_MakePoint(" + x + "," + y + "),4326)");
                allInfo.append(")");
                if (k >= numberOfPoints - 1) continue;
                allInfo.append(",");
                continue;
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().info((Object)("generateXYMap->ERROR IN POINTS " + e.getLocalizedMessage()));
            }
        }
        AnalysisLogger.getLogger().trace((Object)("generateXYMap->putting table elements into " + destinationTable));
        this.connectionsManager.GeoserverUpdate(String.format(rawInsert, destinationTable, "the_geom", allInfo.toString()));
        if (createMap) {
            return this.generatePointGisMap(destinationTable, mapName, localGISInfo);
        }
        return null;
    }

    public String createMapFromPoints(List<Tuple<Float>> xyPoints, String destinationTableName, String mapName, GISInformation gisInfo) throws Exception {
        try {
            this.createTable(destinationTableName);
            String string = this.generateXYMapFromPoints(xyPoints, destinationTableName, true, mapName, gisInfo);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)("Error: " + e.getLocalizedMessage()));
            throw e;
        }
        finally {
            this.connectionsManager.shutdownAll();
        }
    }

    private void createTable(String destinationTableName) {
        AnalysisLogger.getLogger().trace((Object)("createMap->dropping table if exists " + destinationTableName));
        try {
            this.connectionsManager.GeoserverUpdate(String.format(tempTableDrop, destinationTableName));
        }
        catch (Exception e1) {
            AnalysisLogger.getLogger().trace((Object)("createMap->Impossible to drop table " + destinationTableName));
        }
        try {
            AnalysisLogger.getLogger().trace((Object)"createMap->Creating new table");
            this.connectionsManager.GeoserverUpdate(String.format(buildTempTable, destinationTableName));
            this.connectionsManager.GeoserverQuery(String.format(createPointsGeometriesColumn, destinationTableName));
            AnalysisLogger.getLogger().trace((Object)"createMap->Creating new table - OK");
        }
        catch (Exception e2) {
            AnalysisLogger.getLogger().trace((Object)("createMap->Impossible create table " + destinationTableName));
        }
    }

    public String createMap(String originTableName, String destinationTableName, String xDimension, String yDimension, String mapName, GISInformation gisInfo) throws Exception {
        try {
            this.createTable(destinationTableName);
            String string = this.generateXYMap(originTableName, destinationTableName, xDimension, yDimension, true, mapName, gisInfo);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)("Error: " + e.getLocalizedMessage()));
            throw e;
        }
        finally {
            this.connectionsManager.shutdownAll();
        }
    }

    public String generateXYMap(String originTable, String destinationTable, String xDimension, String yDimension, boolean createMap, String mapName, GISInformation gisInfo) throws Exception {
        GISInformation localGISInfo = this.duplicateGISInformation(gisInfo);
        int chunkSize = 100000;
        int startIndex = 0;
        List<Object> rows = this.connectionsManager.TimeSeriesQuery(String.format(rawSelect, xDimension + "," + yDimension, originTable, "" + chunkSize, "" + startIndex));
        while (rows != null) {
            int rowsNumber = rows.size();
            int i = 0;
            StringBuffer allInfo = new StringBuffer();
            for (Object row : rows) {
                Object[] elements = (Object[])row;
                allInfo.append("(");
                String x = "";
                String y = "";
                for (int j = 0; j < elements.length; ++j) {
                    allInfo.append("'" + elements[j] + "',");
                    if (j == 0) {
                        x = "" + elements[j];
                        continue;
                    }
                    if (j != 1) continue;
                    y = "" + elements[j];
                }
                allInfo.append("ST_SetSRID(ST_MakePoint(" + x + "," + y + "),4326)");
                allInfo.append(")");
                if (i < rowsNumber - 1) {
                    allInfo.append(",");
                }
                ++i;
            }
            AnalysisLogger.getLogger().trace((Object)("generateXYMap->putting table elements into " + destinationTable));
            this.connectionsManager.GeoserverUpdate(String.format(rawInsert, destinationTable, "the_geom", allInfo.toString()));
            rows = this.connectionsManager.TimeSeriesQuery(String.format(rawSelect, xDimension + "," + yDimension, originTable, "" + chunkSize, "" + (startIndex += chunkSize)));
        }
        if (createMap) {
            return this.generatePointGisMap(destinationTable, mapName, localGISInfo);
        }
        return null;
    }

    public String generatePointGisMap(String destinationTable, String mapName, GISInformation gisInfo) throws Exception {
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->creating layer");
        GISStyleInformation style = new GISStyleInformation();
        style.setStyleName("point");
        GISLayerInformation gisLayer1 = new GISLayerInformation();
        gisLayer1.setDefaultStyle(style.getStyleName());
        gisLayer1.setLayerName(destinationTable);
        gisLayer1.setLayerTitle(mapName);
        gisInfo.addLayer(gisLayer1);
        gisInfo.addStyle(gisLayer1.getLayerName(), style);
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->adding layers - done!");
        String groupName = "occpoints_" + destinationTable.replace("-", "");
        GISOperations gisOperations = new GISOperations();
        GISGroupInformation gisGroup = new GISGroupInformation();
        gisGroup.setGroupName(groupName);
        gisGroup.setTemplateGroupName(GISOperations.TEMPLATEGROUP);
        gisGroup.setTemplateGroup(true);
        gisInfo.setGroup(gisGroup);
        boolean generated = gisOperations.generateGisMap(gisInfo, true);
        if (!generated) {
            throw new Exception("Impossible to create group on Geonetwork");
        }
        boolean urlcoherence = GISGroupInformation.checkGroup(gisInfo, groupName, 2);
        if (!urlcoherence) {
            return null;
        }
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->GIS Group created!");
        return groupName;
    }
}

