/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class GeoGroupCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<String, Tuple<String>> cache = new HashMap();
    boolean altered = false;
    public String cacheFile;
    static GeoGroupCache singletonCache;
    static int maxElements;

    public GeoGroupCache(String cacheFile) {
        this.cacheFile = cacheFile;
    }

    public Tuple<String> getCachedElement(String timeSeriesName, String geoServerGroup) {
        return this.cache.get(timeSeriesName + ":" + geoServerGroup);
    }

    public void removeCachedElement(String timeSeriesName, String filterName) {
        this.cache.remove(timeSeriesName + ":" + filterName);
        try {
            GeoGroupCache.saveCache(this, this.cacheFile);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Error: Impossible to save cache file");
        }
    }

    public void addCacheElement(String timeSeriesName, String geoServerGroup, String filterName) {
        Iterator<String> i$;
        Tuple<String> groupAnFilter = new Tuple<String>(geoServerGroup);
        if (this.cache.size() > maxElements && (i$ = this.cache.keySet().iterator()).hasNext()) {
            String key = i$.next();
            this.cache.remove(key);
        }
        this.cache.put(timeSeriesName + ":" + filterName, groupAnFilter);
        try {
            GeoGroupCache.saveCache(this, this.cacheFile);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Error: Impossible to save cache file");
        }
        this.altered = true;
    }

    public static void initInstance(String filePath) throws Exception {
        GeoGroupCache.getInstance(filePath);
    }

    public static GeoGroupCache getInstance(String filePath) throws Exception {
        if (singletonCache == null) {
            try {
                singletonCache = GeoGroupCache.getCache(filePath);
            }
            catch (Exception e) {
                singletonCache = new GeoGroupCache(filePath);
            }
        }
        return singletonCache;
    }

    public static void addToCache(String timeSeriesName, String geoServerGroup, String filterName) throws Exception {
        if (singletonCache != null) {
            singletonCache.addCacheElement(timeSeriesName, geoServerGroup, filterName);
        }
    }

    public static GeoGroupCache getCache(String filePath) throws Exception {
        ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(new File(filePath)));
        GeoGroupCache g = (GeoGroupCache)inputStream.readObject();
        inputStream.close();
        return g;
    }

    public static void saveCache(GeoGroupCache cache, String filePath) throws Exception {
        ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(new File(filePath)));
        outStream.writeObject(cache);
        outStream.close();
    }

    static {
        maxElements = 2000;
    }

    class RefreshResources
    extends TimerTask {
        String cacheFile;

        public RefreshResources(String cacheFile) {
            this.cacheFile = cacheFile;
        }

        @Override
        public void run() {
            if (singletonCache != null && GeoGroupCache.singletonCache.altered) {
                try {
                    GeoGroupCache.saveCache(singletonCache, this.cacheFile);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"RefreshResources-> unable to save cache");
                }
            }
        }
    }
}

