/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.gisconnectors;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;

public class GISLayerSaver {
    ConnectionsManager connManager;
    private GISOperations gisOperations;

    public GISLayerSaver(ConnectionsManager connManager) {
        this.connManager = connManager;
    }

    public void createLayerOnDB(GISLayer layer, GISOperations.featuresTypes type) throws Exception {
        String creationStatement = GISOperations.createLayerTableStatement(layer.getLayerName(), layer.getValuesColumnName(), type);
        StringBuffer insertStatement = null;
        this.connManager.GeoserverUpdate(creationStatement);
        int size = layer.getCsquareCodes().size();
        AnalysisLogger.getLogger().warn((Object)("CREATING LAYER: " + creationStatement + " with " + size + " squares"));
        if (size > 0) {
            String insertStatementStart = "insert into " + layer.getLayerName() + " values ";
            insertStatement = new StringBuffer(insertStatementStart);
            for (int i = 0; i < size; ++i) {
                insertStatement.append("(DEFAULT,'" + layer.getCsquareCodes().get(i) + "',NULL,'" + layer.getValues().get(i) + "','" + layer.getInfos().get(i).replace("'", "") + "')");
                if (i >= size - 1) continue;
                insertStatement.append(",");
            }
            AnalysisLogger.getLogger().warn((Object)"Inserting ... ");
            this.connManager.GeoserverUpdate(insertStatement.toString());
            String fulfilQuery = GISOperations.createFulfilGeometriesStatement(layer.getLayerName());
            AnalysisLogger.getLogger().warn((Object)("UPDATING GEOMETRIES: " + fulfilQuery));
            this.connManager.GeoserverUpdate(fulfilQuery);
        }
    }

    public String createGISgroup(List<GISLayer> layers, GISInformation gisInfo, String externalGroupName) {
        return this.createGISgroup(layers, gisInfo, externalGroupName, true, false);
    }

    public GISOperations getGisOperation() {
        return this.gisOperations;
    }

    public String createGISgroup(List<GISLayer> layers, GISInformation gisInfo, String externalGroupName, boolean generateMap, boolean ignoreStyleCreationFailure) {
        String groupName = null;
        if (layers.size() > 0) {
            groupName = externalGroupName == null ? "group4" + UUID.randomUUID() : externalGroupName;
            GISGroupInformation gisGroup = new GISGroupInformation();
            gisGroup.setGroupName(groupName);
            gisGroup.setTemplateGroupName(GISOperations.TEMPLATEGROUP);
            gisGroup.setTemplateGroup(true);
            int numOfClasses = 5;
            double absmaximum = -1.7976931348623157E308;
            double absminimum = Double.MAX_VALUE;
            for (GISLayer layer : layers) {
                double min = layer.getMin();
                double max = layer.getMax();
                if (min < absminimum) {
                    absminimum = min;
                }
                if (!(max > absmaximum)) continue;
                absmaximum = max;
            }
            for (GISLayer layer : layers) {
                if (layer.isEmpty()) continue;
                GISLayerInformation gisLayer1 = new GISLayerInformation();
                gisLayer1 = new GISLayerInformation();
                gisLayer1.setLayerName(layer.getLayerName());
                gisLayer1.setLayerTitle(layer.getLayerTitle());
                GISStyleInformation newstyle = new GISStyleInformation();
                String styleName = layer.getPreferredStyleName() != null ? layer.getPreferredStyleName() : layer.getLayerName();
                newstyle.setStyleName(styleName);
                Color c1 = Color.yellow;
                Color c2 = Color.red;
                newstyle.setGradientBase(c1);
                newstyle.setGradientMax(c2);
                AnalysisLogger.getLogger().trace((Object)("STYLE: MAX:" + layer.getMax() + " MIN:" + layer.getMin()));
                newstyle.setMax(absmaximum);
                newstyle.setMin(absminimum);
                newstyle.setNumberOfClasses(numOfClasses);
                newstyle.setScaleType(GISStyleInformation.Scales.linear);
                newstyle.setStyleAttribute(layer.getValuesColumnName());
                newstyle.setValuesType(Double.class);
                gisLayer1.setDefaultStyle(newstyle.getStyleName());
                gisInfo.addLayer(gisLayer1);
                gisInfo.addStyle(gisLayer1.getLayerName(), newstyle);
            }
            gisInfo.setGroup(gisGroup);
            if (generateMap) {
                if (gisInfo.getLayers().size() > 0) {
                    this.gisOperations = new GISOperations();
                    boolean generated = this.gisOperations.generateGisMap(gisInfo, ignoreStyleCreationFailure);
                    if (!generated) {
                        groupName = null;
                    }
                } else {
                    groupName = null;
                }
            }
        }
        return groupName;
    }
}

