/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.gisconnectors;

import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;

public class GISGroupInformation {
    private String groupName;
    private String templateGroupName;
    private boolean isTemplateGroup;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setTemplateGroupName(String templateGroupName) {
        this.templateGroupName = templateGroupName;
    }

    public String getTemplateGroupName() {
        return this.templateGroupName;
    }

    public void setTemplateGroup(boolean isTemplateGroup) {
        this.isTemplateGroup = isTemplateGroup;
    }

    public boolean isTemplateGroup() {
        return this.isTemplateGroup;
    }

    public static boolean checkGroup(GISInformation gisInfo, String groupName, int maxtries) throws Exception {
        boolean urlcoherence = false;
        GISOperations operations = new GISOperations();
        GeoCaller geoCaller = operations.getGeoCaller(gisInfo);
        String geourl = geoCaller.getGeoServerForGroup(groupName);
        String checkurl = geourl + "/rest/layergroups/" + groupName + ".json";
        for (int i = 0; i < maxtries; ++i) {
            AnalysisLogger.getLogger().debug((Object)("checkGroup->Checking Group on geoserver " + checkurl));
            int result = HttpRequest.checkUrl((String)checkurl, (String)gisInfo.getGisUserName(), (String)gisInfo.getGisPwd());
            AnalysisLogger.getLogger().debug((Object)("checkGroup->Cached Group Checking " + result));
            if (result != 200) continue;
            urlcoherence = true;
            AnalysisLogger.getLogger().debug((Object)("checkGroup->GROUP PRESENT IN " + geourl));
            break;
        }
        return urlcoherence;
    }
}

