/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.databases;

import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class ConnectionsManager {
    private SessionFactory timeSeriesConnection;
    private String timeSeriesConnectionFile = "TimeSeriesConnection.hibernate.xml";
    private EngineConfiguration timeSeriesConfiguration;
    private SessionFactory aquamapsConnection;
    private String aquamapsConnectionFile = "AquamapsConnection.hibernate.xml";
    private EngineConfiguration aquamapsConfiguration;
    private SessionFactory geoserverConnection;
    private String geoServerConnectionFile = "GeoServerConnection.hibernate.xml";
    private EngineConfiguration geoServerConfiguration;
    private String cachePath = "";

    public SessionFactory getTimeSeriesConnection() {
        return this.timeSeriesConnection;
    }

    public static String getTableName(String tableName) {
        return tableName.toLowerCase();
    }

    public void setAquamapsConnection(SessionFactory aquamapsConnection) {
        this.aquamapsConnection = aquamapsConnection;
    }

    public SessionFactory getAquamapsConnection() {
        return this.aquamapsConnection;
    }

    public void setGeoserverConnection(SessionFactory geoserverConnection) {
        this.geoserverConnection = geoserverConnection;
    }

    public SessionFactory getGeoserverConnection() {
        return this.geoserverConnection;
    }

    public ConnectionsManager(String cachePath) {
        this.cachePath = cachePath;
    }

    public void initTimeSeriesConnection(EngineConfiguration configuration) throws Exception {
        this.setTimeSeriesConfiguration(configuration);
        this.timeSeriesConnection = DatabaseFactory.initDBConnection((String)(this.cachePath + this.timeSeriesConnectionFile), (LexicalEngineConfiguration)configuration);
    }

    public void initAquamapsConnection(EngineConfiguration configuration) throws Exception {
        this.setAquamapsConfiguration(configuration);
        this.aquamapsConnection = DatabaseFactory.initDBConnection((String)(this.cachePath + this.aquamapsConnectionFile), (LexicalEngineConfiguration)configuration);
    }

    public void initGeoserverConnection(EngineConfiguration configuration) throws Exception {
        this.setGeoServerConfiguration(configuration);
        this.geoserverConnection = DatabaseFactory.initDBConnection((String)(this.cachePath + this.geoServerConnectionFile), (LexicalEngineConfiguration)configuration);
    }

    public void GeoserverUpdate(String updateQuery) throws Exception {
        DatabaseFactory.executeSQLUpdate((String)updateQuery, (SessionFactory)this.geoserverConnection);
    }

    public void AquamapsUpdate(String updateQuery) throws Exception {
        DatabaseFactory.executeSQLUpdate((String)updateQuery, (SessionFactory)this.aquamapsConnection);
    }

    public void TimeSeriesUpdate(String updateQuery) throws Exception {
        DatabaseFactory.executeSQLUpdate((String)updateQuery, (SessionFactory)this.timeSeriesConnection);
    }

    public List<Object> GeoserverQuery(String query) throws Exception {
        return DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.geoserverConnection);
    }

    public List<Object> AquamapsQuery(String query) throws Exception {
        return DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.aquamapsConnection);
    }

    public List<Object> TimeSeriesQuery(String query) throws Exception {
        return DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.timeSeriesConnection);
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public void setTimeSeriesConfiguration(EngineConfiguration timeSeriesConfiguration) {
        this.timeSeriesConfiguration = timeSeriesConfiguration;
    }

    public EngineConfiguration getTimeSeriesConfiguration() {
        return this.timeSeriesConfiguration;
    }

    public void setAquamapsConfiguration(EngineConfiguration aquamapsConfiguration) {
        this.aquamapsConfiguration = aquamapsConfiguration;
    }

    public EngineConfiguration getAquamapsConfiguration() {
        return this.aquamapsConfiguration;
    }

    public void setGeoServerConfiguration(EngineConfiguration geoServerConfiguration) {
        this.geoServerConfiguration = geoServerConfiguration;
    }

    public EngineConfiguration getGeoServerConfiguration() {
        return this.geoServerConfiguration;
    }

    public void shutdownAll() {
        try {
            this.aquamapsConnection.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.geoserverConnection.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.timeSeriesConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

