/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.stubs.calls.codelist;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnTypeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckNullValuesOnDataTypeChangeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodeListType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistCurationManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnterInEditModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.RemoveColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetCLLabelRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetPropertiesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartCurationModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.codelist.CodeListCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistCurationManagerServiceAddressingLocator;

public class CodelistCurationCall
extends CodeListCall {
    private static HashMap<String, CodelistCurationManagerPortType> clCurationManagerPTMapping = new HashMap();
    private String user;
    private String id;
    private CodelistCurationManagerPortType cachedPT;

    private static String getEndpoint() {
        return "gcube/contentmanagement/timeseriesservice/codelist/CodelistCuration";
    }

    public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception {
        CodelistCurationManagerPortType pt = new CodelistCurationManagerServiceAddressingLocator().getCodelistCurationManagerPortTypePort(epr);
        pt = (CodelistCurationManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        clCurationManagerPTMapping.put(scope.toString(), pt);
    }

    private static CodelistCurationManagerPortType getCodelistCurationManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        if (clCurationManagerPTMapping.get(scope.toString()) == null) {
            CodelistCurationManagerPortType pt = new CodelistCurationManagerServiceAddressingLocator().getCodelistCurationManagerPortTypePort(CodelistCurationCall.getEpr(scope, CodelistCurationCall.getEndpoint()));
            pt = (CodelistCurationManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])securityManager);
            clCurationManagerPTMapping.put(scope.toString(), pt);
        }
        return clCurationManagerPTMapping.get(scope.toString());
    }

    public static String startCurationMode(String importId, String user, CodeListType type, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws NoServiceFoundException, Exception {
        CodelistCurationManagerPortType pt = CodelistCurationCall.getCodelistCurationManagerPortType(scope, securityManagers);
        return pt.startCurationMode(new StartCurationModeRequest(type, importId, user));
    }

    public static List<CLUnderCurationItem> getItems(String user, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        CLUnderCurationItemsArray clArray = CodelistCurationCall.getCodelistCurationManagerPortType(scope, securityManager).getUnderCurationCodelists(user);
        if (clArray.getItems() == null) {
            return new ArrayList<CLUnderCurationItem>();
        }
        return Arrays.asList(clArray.getItems());
    }

    public static CLUnderCurationItem getItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        return CodelistCurationCall.getCodelistCurationManagerPortType(scope, securityManager).getCLUnderCurationItem(new CodelistIdentifier(id, user));
    }

    public CodelistCurationCall(String user, String id, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws NoServiceFoundException, Exception {
        this.id = id;
        this.user = user;
        this.cachedPT = CodelistCurationCall.getCodelistCurationManagerPortType(scope, securityManagers);
    }

    public void removeColumn(String fieldId) throws Exception {
        this.cachedPT.removeColumn(new RemoveColumnRequest(fieldId, new CodelistIdentifier(this.id, this.user)));
    }

    public void removeRow(int ... rows) throws Exception {
    }

    public boolean checkCodeListCurationFinished() throws Exception {
        return this.cachedPT.checkCodeListCurationFinished(new CodelistIdentifier(this.id, this.user));
    }

    public boolean remove() throws Exception {
        return this.cachedPT.remove(new CodelistIdentifier(this.id, this.user));
    }

    public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception {
        ArrayList<CodelistColumnDefinition> toReturn = new ArrayList<CodelistColumnDefinition>();
        for (CodelistColumnDefinition cdef : this.cachedPT.getColumnsDefinition(new CodelistIdentifier(this.id, this.user)).getDefinition()) {
            toReturn.add(cdef);
        }
        return toReturn;
    }

    public String getDataAsJson(Limit limit, Order order) throws Exception {
        return this.cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(this.id, this.user), limit, order));
    }

    public void changeColumnType(String fieldId, CodelistColumnType columnType) throws Exception {
        this.cachedPT.changeColumnType(new ChangeColumnTypeRequest(columnType, fieldId, new CodelistIdentifier(this.id, this.user), null));
    }

    public void changeColumnType(String fieldId, CodelistColumnType columnType, String codeListReferenceId) throws Exception {
        this.cachedPT.changeColumnType(new ChangeColumnTypeRequest(columnType, fieldId, new CodelistIdentifier(this.id, this.user), codeListReferenceId));
    }

    public int checkCorrectness(String fieldId, DataType newType) throws Exception {
        return this.cachedPT.checkNullValuesOnDataTypeChange(new CheckNullValuesOnDataTypeChangeRequest(null, null, newType, fieldId, new CodelistIdentifier(this.id, this.user)));
    }

    public int checkCorrectness(String fieldId, CodelistColumnType columnType, String relatedCodelistId) throws Exception {
        return this.cachedPT.checkNullValuesOnDataTypeChange(new CheckNullValuesOnDataTypeChangeRequest(relatedCodelistId, columnType, null, fieldId, new CodelistIdentifier(this.id, this.user)));
    }

    public void edit(String fieldId, DataType newType) throws Exception {
        this.cachedPT.enterInEditMode(new EnterInEditModeRequest(newType, fieldId, new CodelistIdentifier(this.id, this.user)));
    }

    public void edit(String fieldId) throws Exception {
        this.cachedPT.enterInEditMode(new EnterInEditModeRequest(null, fieldId, new CodelistIdentifier(this.id, this.user)));
    }

    public State getEditingStatus() throws Exception {
        return this.cachedPT.getEditingStatus(new CodelistIdentifier(this.id, this.user));
    }

    public boolean isUnderEditing() throws Exception {
        return this.cachedPT.isUnderEditing(new CodelistIdentifier(this.id, this.user));
    }

    public void removeEdit() throws Exception {
        this.cachedPT.removeEdit(new CodelistIdentifier(this.id, this.user));
    }

    public void replaceValue(String newValue, int rowId, String fieldId) throws Exception {
        this.cachedPT.replaceValue(new ReplaceValueRequest(fieldId, new CodelistIdentifier(this.id, this.user), newValue, rowId));
    }

    public CodelistColumnDefinition getColumnInEditMode() throws Exception {
        return this.cachedPT.getColumnDefinitionUnderEdit(new CodelistIdentifier(this.id, this.user));
    }

    public int getErrorCount() throws Exception {
        return this.cachedPT.getErrorCount(new CodelistIdentifier(this.id, this.user));
    }

    public int getSize() throws Exception {
        return this.cachedPT.getSize(new CodelistIdentifier(this.id, this.user));
    }

    public void removeAllErrors() throws Exception {
        this.cachedPT.removeAllErrors(new CodelistIdentifier(this.id, this.user));
    }

    public void saveEditing() throws Exception {
        this.cachedPT.saveEdit(new CodelistIdentifier(this.id, this.user));
    }

    public void setLabel(String fieldId, String label) throws Exception {
        this.cachedPT.setLabel(new SetCLLabelRequest(fieldId, new CodelistIdentifier(this.id, this.user), label));
    }

    public State getCurationStatus() throws Exception {
        return this.cachedPT.getCurationStatus(new CodelistIdentifier(this.id, this.user));
    }

    public void setProperties(String agencyId, String description, boolean isFinal, String name, float version) throws Exception {
        this.cachedPT.setProperties(new SetPropertiesRequest(agencyId, description, new CodelistIdentifier(this.id, this.user), isFinal, name, version));
    }

    public String getCodes(Limit limit, Order order) throws Exception {
        return this.cachedPT.getCodes(new DataAsJsonRequest(new CodelistIdentifier(this.id, this.user), limit, order));
    }
}

