/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Selection;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableFromSubselect;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.CompatibleColumnsMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FieldMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class Union
extends Operation {
    private static final long serialVersionUID = -8743629616088928149L;
    private static GCUBELog logger = new GCUBELog(Union.class);
    private String secondResourceId;
    private FieldMapping[] fieldMappingList;

    public Union() throws Exception {
        this.type = OperationType.Union;
        this.viewName = "u" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        logger.trace((Object)"initializing union");
        LinkedList<AssignedAttribute> firstTableAttributes = new LinkedList<AssignedAttribute>();
        LinkedList<AssignedAttribute> secondTableAttributes = new LinkedList<AssignedAttribute>();
        LinkedList<ColumnDefinition> newColumnDefinition = new LinkedList<ColumnDefinition>();
        int fieldId = 0;
        FieldMapping[] fieldMappingArray = this.fieldMappingList;
        int n = this.fieldMappingList.length;
        int n2 = 0;
        while (n2 < n) {
            FieldMapping fieldMapping = fieldMappingArray[n2];
            String newFieldId = "field" + fieldId;
            String dimensionId = "";
            logger.trace((Object)("source field is " + fieldMapping.getSourceField() + ", destination field is " + fieldMapping.getDestinationField() + ", new field name is" + newFieldId));
            firstTableAttributes.add(new AssignedAttribute(new SimpleAttribute(newFieldId), (Object)new SimpleAttribute(fieldMapping.getSourceField())));
            secondTableAttributes.add(new AssignedAttribute(new SimpleAttribute(newFieldId), (Object)new SimpleAttribute(fieldMapping.getDestinationField())));
            ColumnDefinition definition = Union.getColumnDefinitionReference(fieldMapping.getSourceField(), previousTableDefinition);
            if (definition.getColumnType() == EntryType.Dimension) {
                dimensionId = String.valueOf(newFieldId) + "_id";
                firstTableAttributes.add(new AssignedAttribute(new SimpleAttribute(dimensionId), (Object)new SimpleAttribute(String.valueOf(fieldMapping.getSourceField()) + "_id")));
                secondTableAttributes.add(new AssignedAttribute(new SimpleAttribute(dimensionId), (Object)new SimpleAttribute(String.valueOf(fieldMapping.getDestinationField()) + "_id")));
            }
            newColumnDefinition.add(new ColumnDefinition(definition.getColumnType(), definition.getDimension(), dimensionId, newFieldId, definition.getKey(), fieldMapping.getLabel(), definition.getValueType()));
            ++fieldId;
            ++n2;
        }
        this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));
        org.gcube.common.dbinterface.queries.Union unionQuery = (org.gcube.common.dbinterface.queries.Union)DBSession.getImplementation(org.gcube.common.dbinterface.queries.Union.class);
        Select leftQuery = (Select)DBSession.getImplementation(Select.class);
        leftQuery.setAttributes(firstTableAttributes.toArray(new Attribute[0]));
        leftQuery.setTables(new Table[]{new Table(previuosTableName)});
        Select rightQuery = (Select)DBSession.getImplementation(Select.class);
        rightQuery.setAttributes(secondTableAttributes.toArray(new Attribute[0]));
        rightQuery.setTables(new Table[]{Union.getResource(this.secondResourceId).getTable()});
        unionQuery.setLeftQuery((Selection)leftQuery);
        unionQuery.setRightQuery((Selection)rightQuery);
        TableFromSubselect table = new TableFromSubselect("temp", (Selection)unionQuery);
        Select query = (Select)DBSession.getImplementation(Select.class);
        query.setTables(new Table[]{table});
        this.createTable(query, session, true);
        this.viewTable.initializeCount();
        this.setCount(this.viewTable.getCount());
        logger.debug((Object)("the count for union is " + this.viewTable.getCount()));
        this.setHistoryItem(new TSHistoryItem("TO DO", "Union with [" + Union.getResource(this.secondResourceId).getTitle() + "]", new Date(), OperationType.Union));
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        this.secondResourceId = (String)parameters[0];
        this.fieldMappingList = (FieldMapping[])parameters[1];
    }

    public static boolean checkCompatibility(ColumnDefinition[] sourceDefinition, ColumnDefinition[] destinationDefinition) {
        logger.trace((Object)("checking compatibility src size is " + sourceDefinition.length + " and dest size is " + destinationDefinition.length));
        ColumnDefinition[] columnDefinitionArray = sourceDefinition;
        int n = sourceDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition sourceDef = columnDefinitionArray[n2];
            boolean isColumncompatible = false;
            ColumnDefinition[] columnDefinitionArray2 = destinationDefinition;
            int n3 = destinationDefinition.length;
            int n4 = 0;
            while (n4 < n3) {
                ColumnDefinition destinationdef = columnDefinitionArray2[n4];
                logger.trace((Object)("src def type is " + sourceDef.getColumnType() + " and dest type is " + destinationdef.getColumnType()));
                if (sourceDef.getColumnType() == destinationdef.getColumnType()) {
                    logger.trace((Object)"src and dest are compatible .. cheching types");
                    if (sourceDef.getColumnType() == EntryType.Value && sourceDef.getValueType() == destinationdef.getValueType()) {
                        logger.trace((Object)(String.valueOf(sourceDef.getId()) + "," + destinationdef.getId() + " entry type for both is value and src type is " + sourceDef.getValueType().toString() + " dst type is " + destinationdef.getValueType().toString()));
                        isColumncompatible = true;
                        break;
                    }
                    if (sourceDef.getColumnType() == EntryType.Attribute && sourceDef.getValueType() == destinationdef.getValueType()) {
                        logger.trace((Object)(String.valueOf(sourceDef.getId()) + "," + destinationdef.getId() + " entry type for both is attribute and src type is " + sourceDef.getValueType().toString() + " dst type is " + destinationdef.getValueType().toString()));
                        isColumncompatible = true;
                        break;
                    }
                    if (sourceDef.getColumnType() == EntryType.Dimension) {
                        logger.trace((Object)(String.valueOf(sourceDef.getId()) + "," + destinationdef.getId() + " entry type for both is dimension and src id is " + sourceDef.getDimension().getId() + " dst id is " + destinationdef.getDimension().getId()));
                        if (sourceDef.getDimension().getId().equals(destinationdef.getDimension().getId())) {
                            isColumncompatible = true;
                            break;
                        }
                    }
                }
                ++n4;
            }
            logger.trace((Object)(String.valueOf(sourceDef.getId()) + " has a compatibility"));
            if (!isColumncompatible) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static CompatibleColumnsMapping[] getCompatibileColumns(ColumnDefinition[] sourceDefinition, ColumnDefinition[] destinationDefinition) throws Exception {
        ArrayList<CompatibleColumnsMapping> compatibleColumnslist = new ArrayList<CompatibleColumnsMapping>(sourceDefinition.length);
        ColumnDefinition[] columnDefinitionArray = sourceDefinition;
        int n = sourceDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition sourceDef = columnDefinitionArray[n2];
            CompatibleColumnsMapping columnMapping = new CompatibleColumnsMapping();
            columnMapping.setSourceColumnDefinition(sourceDef);
            ArrayList<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>();
            ColumnDefinition[] columnDefinitionArray2 = destinationDefinition;
            int n3 = destinationDefinition.length;
            int n4 = 0;
            while (n4 < n3) {
                ColumnDefinition destinationDef = columnDefinitionArray2[n4];
                if (sourceDef.getColumnType() == destinationDef.getColumnType()) {
                    if (sourceDef.getColumnType() == EntryType.Value && sourceDef.getValueType() == destinationDef.getValueType()) {
                        columnDefinitionList.add(destinationDef);
                    } else if (sourceDef.getColumnType() == EntryType.Attribute && sourceDef.getValueType() == destinationDef.getValueType()) {
                        columnDefinitionList.add(destinationDef);
                    } else if (sourceDef.getColumnType() == EntryType.Dimension && sourceDef.getDimension().getId() == destinationDef.getDimension().getId()) {
                        columnDefinitionList.add(destinationDef);
                    }
                }
                ++n4;
            }
            columnMapping.setCompatibleColumnsList(columnDefinitionList.toArray(new ColumnDefinition[0]));
            compatibleColumnslist.add(columnMapping);
            ++n2;
        }
        return compatibleColumnslist.toArray(new CompatibleColumnsMapping[0]);
    }

    public FieldMapping[] getFieldMappingList() {
        return this.fieldMappingList;
    }

    public void setFieldMappingList(FieldMapping[] fieldMappingList) {
        this.fieldMappingList = fieldMappingList;
    }
}

