package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.util.List;

import org.gcube.contentmanagement.timeseries.geotools.engine.TimeSeriesGISConverter;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIEffortAggregator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

public class GISTransformationObject {

	private TimeSeriesGISConverter converter =null;
	
	private VTIEffortAggregator aggregator =null;
	
	private Status trasformationStatus=Status.Initializing;

	public enum TYPE{GIStransformation, FishingMontlyEffort};
	
	private TYPE type;
	
	private String cause="";
	
	private List<String> resultLayers;
	
	public GISTransformationObject(TimeSeriesGISConverter converter) {
		super();
		this.type = TYPE.GIStransformation;
		this.converter = converter;
	}

	public GISTransformationObject(VTIEffortAggregator aggregator) {
		super();
		this.type = TYPE.FishingMontlyEffort;
		this.aggregator = aggregator;
	}
	
	/**
	 * @return the converter
	 */
	public TimeSeriesGISConverter getConverter() {
		return converter;
	}

	public VTIEffortAggregator getAggregator() {
		return aggregator;
	}
	
	
	
	/**
	 * @return the type
	 */
	public TYPE getType() {
		return type;
	}

	/**
	 * @return the trasformationStatus
	 */
	public Status getTrasformationStatus() {
		return trasformationStatus;
	}

	/**
	 * @return the cause
	 */
	public String getCause() {
		return cause;
	}

	/**
	 * @param cause the cause to set
	 */
	public void setCause(String cause) {
		this.cause = cause;
	}

	/**
	 * @param trasformationStatus the trasformationStatus to set
	 */
	public void setTrasformationStatus(Status trasformationStatus) {
		this.trasformationStatus = trasformationStatus;
	}

	public List<String> getResultLayers() {
		return resultLayers;
	}

	public void setResultLayers(List<String> resultLayers) {
		this.resultLayers = resultLayers;
	}
	
	
	
}
