package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.io.StringReader;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.BaseNotificationConsumer;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.NotificationEvent;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;


public class ConfigurationConsumer extends BaseNotificationConsumer{

	private static GCUBELog logger = new GCUBELog(ConfigurationConsumer.class);
	
	private GCUBEScope scope;

	public ConfigurationConsumer(GCUBEScope scope) {
		super();
		this.scope = scope;
	}
		
	public void onNotificationReceived(NotificationEvent event){
		try{
			logger.trace("notification  received for configuration resource");
			//String id= event.getPayload().getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
			String operation=event.getPayload().getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
			if (operation.equals("create") || operation.equals("update")){
				String profile=event.getPayload().getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
				GCUBEGenericResource resource = GHNContext.getImplementation(GCUBEGenericResource.class);
				resource.load(new StringReader(profile));
				ServiceContext.getContext().parseAndSaveConfiguration(resource, scope);
			}
		}catch (Exception e) {
			logger.warn("error parsing notified configuration resource",e);
		}
	}
}
