package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;

public class ColumnDefinitionImpl{

	private static GCUBELog logger= new GCUBELog(ColumnDefinitionImpl.class);
	
	private ColumnDefinition coldef; 
	
	public ColumnDefinitionImpl(ColumnDefinition coldef){
		this.coldef= coldef;
	}
	
	

	@Override
	public synchronized boolean equals(Object obj) {
		logger.trace("checking equals");
		ColumnDefinition def=(ColumnDefinition)obj;
		if (def.getColumnType()!=coldef.getColumnType() || def.getId().compareTo(coldef.getId())!=0) return false;
		if (def.getColumnType()==EntryType.Dimension)
			return def.getDimension().getId()==coldef.getDimension().getId() && def.getKey().getName().compareTo(coldef.getKey().getName())==0;
		if (def.getColumnType()==EntryType.Attribute)
		    return def.getValueType()==coldef.getValueType();
		if (def.getColumnType()==EntryType.Value)
		    return def.getValueType()==coldef.getValueType();
		logger.trace("I'm returning false for ");
		return false;
	}
	
}
