package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.IsInOperator;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.conditions.StringArray;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Update;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableFromSubselect;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.lexicalmatcher.analysis.run.CategoryGuesser;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem.OperationType;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.ValueNotCompatibleFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;



public class DimensionEditor extends Edit{

	

	/**
	 * 
	 */
	private static final long serialVersionUID = -2639004246980289519L;

	private static transient GCUBELog logger= new GCUBELog(DimensionEditor.class);
		
	
	private Type oldColumnType;
	private String keyId;
	private String keyName;
	private Type keyType;
	private String codeFieldIdInDimension;
	private Type codeTypeInDimension;
	private String dimensionTableNameHuman;
	//private AssignedAttribute attributeToChange;
	
	private Collection<Attribute> attributesList;
	private String codelistId;
	protected SimpleTable dimensionTable;
	
	/**
	 * constructor
	 * 
	 * @param resourceId the associated resource id
	 * @param fieldId the field id 
	 * @param dimensionId the dimension id
	 * @param keyName the key name
	 * @param resourceTableName the resource table name
	 * @param withoutError the error check 
	 * @param fieldlength the length of the fields
	 * @param resourceTableCount the number of entries in the original table
	 * @throws Exception -
	 */
	public DimensionEditor(String resourceId, String fieldId, String codelistId, String keyId, SimpleTable resourceTable,  int[] fieldlength,int resourceTableCount, boolean withoutErrors) throws Exception{
		super(resourceId, fieldId, resourceTable, fieldlength, withoutErrors);
		this.editorType= TYPE.Dimesion;
		
		CodeList codelist = CodeList.get(codelistId);
		this.dimensionTable=codelist.getTable();
		this.dimensionTableNameHuman=codelist.getName();
		this.keyName = codelist.getLabelFieldMapping().get(keyId).getFieldName();	
		this.codelistId=codelistId;
		this.keyId= keyId;
		this.codeFieldIdInDimension = codelist.getCodeColumnId();
		this.codeTypeInDimension = codelist.getTable().getFieldsMapping().get(codeFieldIdInDimension);
		this.historyEditorList.add(new CurationHistoryItem("","for column "+fieldId+" setting dimension "+this.dimensionTableNameHuman+" and key id "+this.keyId,new Timestamp(System.currentTimeMillis()),OperationType.COLUMN_TYPE_SET));
	}
	
	/**
	 * initializes the Field Editor
	 * 
	 * @throws Exception
	 */
	public void internalInitialize(DBSession session) throws Exception{
		this.keyType=this.dimensionTable.getFieldsMapping().get(this.keyId);
		this.resourceTable.initializeFieldMapping();
		Collection<Attribute> correctTableReplaceAttributes= new ArrayList<Attribute>();
		List<Attribute> correctCurationTableAttributeToTake= new ArrayList<Attribute>();
		List<Attribute> wrongCurationTableAttributeToTake= new ArrayList<Attribute>();
		List<ColumnDefinition> correctColumnDefinitionArray=new ArrayList<ColumnDefinition>(this.resourceTable.getFieldsMapping().size());
		List<ColumnDefinition> wrongColumnDefinitionArray=new ArrayList<ColumnDefinition>(this.resourceTable.getFieldsMapping().size());
		for (Entry<String, Type> entry:this.resourceTable.getFieldsMapping().entrySet()){
			ColumnDefinition colDef = null;
			if (entry.getKey().equals(this.fieldId)){
				colDef= Utility.getColumnDefinition(entry.getKey(), this.keyType);
				//CastObject cast= Utility.getCast(new SimpleAttribute(entry.getKey()), this.keyType);
				//cast.setUseCastFunction(true);
				//attributeToChange = new AssignedAttribute<Object>(new SimpleAttribute(entry.getKey()), this.keyType.getType().getDefaultValue());
				//correctTableReplaceAttributes.add(attributeToChange);
				CastObject castCur= Utility.getCast(new SimpleAttribute(entry.getKey(), CURATION_TABLE_ALIAS), this.keyType);
				castCur.setUseCastFunction(true);
				correctCurationTableAttributeToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(entry.getKey()), castCur));
				wrongCurationTableAttributeToTake.add(new SimpleAttribute(entry.getKey()));
				
				//saving the old column type
				this.oldColumnType = entry.getValue();
				correctColumnDefinitionArray.add(colDef);
				
				wrongColumnDefinitionArray.add(Utility.getColumnDefinition(entry.getKey(),entry.getValue()));
							
			}else if (!entry.getKey().equals(this.fieldId+CurationResource.ID_COLUMN_SUFFIX)){
				colDef= Utility.getColumnDefinition(entry.getKey(), entry.getValue());
				correctTableReplaceAttributes.add(new SimpleAttribute(entry.getKey()));
				correctCurationTableAttributeToTake.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(entry.getKey()), new SimpleAttribute(entry.getKey(), CURATION_TABLE_ALIAS)));
				wrongCurationTableAttributeToTake.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(entry.getKey()), new SimpleAttribute(entry.getKey(), CURATION_TABLE_ALIAS)));
				correctColumnDefinitionArray.add(colDef);
				wrongColumnDefinitionArray.add(colDef);
			}
		}

		//if (!isAlreadyADimension) {
		ColumnDefinition colDef=Utility.getColumnDefinition(this.fieldId+CurationResource.ID_COLUMN_SUFFIX, this.codeTypeInDimension);
		//correctTableReplaceAttributes.add(new AssignedAttribute<Object>(new SimpleAttribute(this.fieldId+CurationResource.ID_COLUMN_SUFFIX), this.codeTypeInDimension.getType().getDefaultValue()));					
		correctColumnDefinitionArray.add(colDef);
		wrongColumnDefinitionArray.add(colDef);
		//}

		CreateTable createQuery= DBSession.getImplementation(CreateTable.class);
		createQuery.setTableName(getCorrectsTableName());
		createQuery.setColumnsDefinition(correctColumnDefinitionArray.toArray(new ColumnDefinition[correctColumnDefinitionArray.size()]));
		logger.trace("corrects table: "+createQuery.getExpression());
		createQuery.execute(session);

		/*
			for (String field: this.correctFieldsTable.getFieldsMapping().keySet())
				Utility.createIndexOnField(this.correctFieldsTable, field, false).execute(session);
		 */

		//the count field is only for wrongs entries table
		wrongColumnDefinitionArray.add(Utility.getColumnDefinition(COUNT_ALIAS, new Type(Types.INTEGER,8)));

		//createContraint.add(COUNT_ALIAS+" integer(8)");
		//creating wrong table
		CreateTable createWrongQuery= DBSession.getImplementation(CreateTable.class);
		createWrongQuery.setTableName(getWrongsTableName());
		createWrongQuery.setColumnsDefinition(wrongColumnDefinitionArray.toArray(new ColumnDefinition[0]));
		logger.trace("wrongs table:  "+createWrongQuery.getExpression());
		createWrongQuery.execute(session);
		//TODO: create indexes

		this.insertCorretElementsTable(session, correctCurationTableAttributeToTake);

		//selecting the wrong entries (with ids)
		this.insertWrongElementsTable(session, wrongCurationTableAttributeToTake);
		this.attributesList = Collections.unmodifiableCollection(correctTableReplaceAttributes);
	}
	

	/**
	 * 
	 * @return the filed id
	 */
	public String getFieldId(){
		return this.fieldId;
	}

	
	/**
	 * 
	 * @return the key type
	 */
	public Type getKeyType() {
		return keyType;
	}

	/**
	 * set the key type
	 * 
	 * @param keyType key type to set
	 */
	public void setKeyType(Type keyType) {
		this.keyType = keyType;
	}

	
	/**
	 * 
	 * @return the key name
	 */
	public String getKeyId() {
		return keyId;
	}

	/**
	 * sets the key name
	 * @param keyName key name to set
	 */
	public void setKeyName(String keyId) {
		this.keyId = keyId;
	}

	/**
	 * 
	 * @return the dimension id
	 */
	public String getCodelistId() {
		return codelistId;
	}

	/**
	 * sets the dimension id
	 * 
	 * @param dimensionId dimension id
	 */
	public void setCodelistId(String codelistId) {
		this.codelistId = codelistId;
	}

	/**
	 * returns the table name human readable
	 * @return the table name
	 */
	public String getDimensionTableNameHuman() {
		return dimensionTableNameHuman;
	}
	
	/**
	 * sets the dimension table name human
	 * 
	 * @param dimensionTableNameHuman the table name
	 */
	public void setDimensionTableNameHuman(String dimensionTableNameHuman) {
		this.dimensionTableNameHuman = dimensionTableNameHuman;
	}
	
	
	/**
	 * modifies an entry with a specific fieldId with the entry corresponding to the newId in the entry with selected row id  
	 * 
	 * @param fieldId the field id
	 * @param newId the new id 
	 * @param rowId the row id
	 * @throws Exception -
	 */
	public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception{
		logger.info("modifying a column under editing with values "+fieldId+ " "+newId+" "+rowId);
		DBSession session= DBSession.connect();
		Select selectQuery= DBSession.getImplementation(Select.class);
		selectQuery.setAttributes(new SimpleAttribute(this.keyId));
		CastObject idCast= Utility.getCast(newId, this.codeTypeInDimension);
		selectQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(this.codeFieldIdInDimension),idCast,"="));
		selectQuery.setTables(this.dimensionTable);
		logger.trace("select query for check value compatibility is "+selectQuery.getExpression());
		ResultSet selectQueryRS=selectQuery.getResults(session);
				
		if (selectQueryRS.next())  {
			String newValue=selectQueryRS.getString(1);
			//this.valueSizeControl(newValue, this.keyType);
			try{
				ArrayList<Attribute> attributesToTake = cloneAttributeList();
				CastObject cast=Utility.getCast(newValue, keyType);
				attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), cast));
				attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast));
				
				//moving entries from wrong to correct
				Select modifiedEntriesQuery= DBSession.getImplementation(Select.class);
				modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0])); 
				
				modifiedEntriesQuery.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL), new Long(rowId), "="));
				modifiedEntriesQuery.setTables(getWrongsTable());
				
				//Insert modifiedEntries 
				InsertFromSelect insert=DBSession.getImplementation(InsertFromSelect.class);
				insert.setSubQuery(modifiedEntriesQuery);
				insert.setTable(getCorrectsTable());
				logger.trace("insert query for modifyEntryId is "+insert.getExpression());
				insert.execute(session);
				
				//UpdatingEntries in correctTable
				/*Update updateQuery= DBSession.getImplementation(Update.class);
				updateQuery.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL),new Long(rowId),"="));
				CastObject cast=Utility.getCast(newValue, keyType);
				
				updateQuery.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="), new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast, "="));
				updateQuery.setTable(getCorrectsTable());
				updateQuery.execute(session);*/
				//Deleting entries from Wrong table
				Delete deleteQuery= DBSession.getImplementation(Delete.class);
				deleteQuery.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL), new Long(rowId), "="));
				deleteQuery.setTable(getWrongsTable());
				deleteQuery.execute(session);
			}catch(Exception e){logger.warn("error updating wrong entries table",e);}
		} else throw new ValueNotCompatibleFault();
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param newId
	 * @param rowId
	 * @param dimensionId
	 * @param keyName
	 * @throws Exception
	 */
	public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception{
		logger.info("modifying a column under editing");
		
		DBSession session= DBSession.connect();
		try{
			CodeList codelist= CodeList.get(dimensionId);
			String dimTableName=codelist.getTable().getTableName();
			String codeFieldId = codelist.getCodeColumnId();
			Type codeColumnType = codelist.getTable().getFieldsMapping().get(codeFieldId);
			
			CastObject idCast= Utility.getCast(newId, codeColumnType);
			Select newValueQuery=DBSession.getImplementation(Select.class);
			newValueQuery.setAttributes(new SimpleAttribute(keyName));
			newValueQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(codeFieldId),idCast,"="));
			newValueQuery.setTables(new Table(dimTableName));
			ResultSet newValueRS= newValueQuery.getResults(session);


			if (newValueRS.next())  {
				String newValue=newValueRS.getString(0);

				Type keyType=this.resourceTable.getFieldsMapping().get(fieldId);

				CastObject cast= Utility.getCast(newValue, keyType);
				this.valueSizeControl(newValue, keyType);
				try{
					Update updateWrong= DBSession.getImplementation(Update.class);
					updateWrong.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL),new Long(rowId),"="));
					updateWrong.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="), new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast, "="));
					updateWrong.setTable(getWrongsTable());
					updateWrong.execute(session);
				}catch(Exception e){logger.warn("error updating wrong entries table",e);}
				try{
					Update updateCorrect= DBSession.getImplementation(Update.class);
					updateCorrect.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL),new Long(rowId),"="));
					updateCorrect.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="), new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast, "="));
					updateCorrect.setTable(getCorrectsTable());
					updateCorrect.execute(session);
				}catch(Exception e){logger.warn("error updating correct entries table",e);}
			} else
				throw new ValueNotCompatibleFault();
		}finally{
			if (session!=null) session.release();
		}
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param rowId
	 * @param newValue
	 * @throws Exception
	 */
	public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception{
		DBSession session= DBSession.connect();
		try{
			this.valueSizeControl(newValue, this.keyType);
			CastObject cast= Utility.getCast(newValue, this.keyType);
			try{
				Update updateCorrect= DBSession.getImplementation(Update.class);
				updateCorrect.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL),new Long(rowId),"="));
				updateCorrect.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="));
				updateCorrect.setTable(getCorrectsTable());
				updateCorrect.execute(session);
				//new UpdateQuery(new OperatorCondition[]{new OperatorCondition<String, CastObject>(fieldId, new CastObject(newValue,keyType), "=")},this.correctFieldsTableName,new OperatorCondition<String, Long>(ROW_ID_LABEL,new Long(rowId),"=")).execute();
			}catch(Exception e){logger.warn("rowId not found in correct entries table");}
			try{
				Update updateCorrect= DBSession.getImplementation(Update.class);
				updateCorrect.setFilter(new OperatorCondition<SimpleAttribute, Long>(new SimpleAttribute(ROW_ID_LABEL),new Long(rowId),"="));
				updateCorrect.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="));
				updateCorrect.setTable(getWrongsTable());
				updateCorrect.execute(session);
				//new UpdateQuery(new OperatorCondition[]{new OperatorCondition<String, CastObject>(fieldId, new CastObject(newValue,keyType), "=")},this.wrongsFieldTableName,new OperatorCondition<String, Long>(ROW_ID_LABEL,new Long(rowId),"=")).execute();
			}catch(Exception e){logger.warn("rowId not found in wrong entries table");}
		}finally{
			if (session!=null) session.release();
		}
	}
	
	
	/**
	 * 
	 * @param fieldId field id
	 * @param oldId old value id 
	 * @param newId new value id
	 * @throws Exception -
	 */
	public void replaceIds(String fieldId, String oldId, String newId) throws Exception{
		DBSession session= DBSession.connect();
		try{
			Select selectQuery= DBSession.getImplementation(Select.class);
			selectQuery.setAttributes(new SimpleAttribute(this.keyId));
			CastObject idCast= Utility.getCast(newId, this.codeTypeInDimension);
			selectQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(this.codeFieldIdInDimension),idCast,"="));
			selectQuery.setTables(this.dimensionTable);
			ResultSet selectQueryRS=selectQuery.getResults(session);

			if (selectQueryRS.next()) {
				String newValue=selectQueryRS.getString(0);
				try{
					ArrayList<Attribute> attributesToTake = cloneAttributeList();
					CastObject cast=Utility.getCast(newValue, keyType);
					attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), cast));
					attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast));
					
					CastObject oldIdCast= Utility.getCast(oldId, this.codeTypeInDimension);
					
					//moving entries from wrong to correct
					Select modifiedEntriesQuery= DBSession.getImplementation(Select.class);
					modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0])); 
					modifiedEntriesQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), oldIdCast, "="));
					modifiedEntriesQuery.setTables(getWrongsTable());

					//Insert modifiedEntries 
					InsertFromSelect insert=DBSession.getImplementation(InsertFromSelect.class);
					insert.setSubQuery(modifiedEntriesQuery);
					insert.setTable(getCorrectsTable());
					insert.execute(session);

					//UpdatingEntries in correctTable
					/*Update updateQuery= DBSession.getImplementation(Update.class);
					updateQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), oldIdCast, "="));
					CastObject cast = Utility.getCast(newValue, keyType);
					
					updateQuery.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast, "="), new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), cast, "="));
					updateQuery.setTable(getCorrectsTable());
					updateQuery.execute(session);*/

					//Deleting entries from Wrong table
					Delete deleteQuery= DBSession.getImplementation(Delete.class);
					deleteQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX),oldIdCast , "="));
					deleteQuery.setTable(getWrongsTable());
					deleteQuery.execute(session);

				}catch(Exception e){logger.error("error replacing entries",e);}

			} else throw new ValueNotCompatibleFault();
		}finally{
			if (session!=null) session.release();
		}
	}
	

	/**
	 * 
	 * @param fieldId field id
	 * @param newValue new value
	 * @param oldValue old value
	 * @throws Exception -
	 */
	public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception{
		//TODO
	}

	
	/**
	 * 
	 * @param fieldId field id 
	 * @param oldValue old value
	 * @param newValue new value
	 * @throws Exception -
	 */
	public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception{
		//TODO
	}
	
	/**
	 * 
	 * @return a map of field and length
	 */
	public int[] getFieldLength() {
		return fieldlength;
	}

	/**
	 * 
	 * @param fieldLength the field length
	 */
	public void setFieldLength(int[] fieldLength) {
		this.fieldlength = fieldLength;
	}
	
	
	private void valueSizeControl(String value, Type keyType) throws Exception{
		if (value.length()>this.fieldlength[0]){
			DBSession session= DBSession.connect();
			ModifyColumnType modColumn=DBSession.getImplementation(ModifyColumnType.class);
			modColumn.setColumn(new SimpleAttribute(fieldId));
			modColumn.setNewType(new Type(keyType.getType(),value.length()));
			modColumn.setTable(getCorrectsTable());
			modColumn.execute(session);
			//reusing modColumn for wrongEntriesTable
			modColumn.setTable(getWrongsTable());
			modColumn.execute(session);
			int precisionFloat= 0;
			if (value.contains("."))
				precisionFloat= value.split("\\.")[1].length();
			this.fieldlength=new int[]{value.length(),precisionFloat};
			session.release();
		}
	}
	
	/**
	 * 
	 * @param oldValue old value
	 * @param newId new value id 
	 * @param fieldId field id
	 * @throws Exception -
	 */
	public void replaceEntryValueWithId(String oldValue, String newId,
			String fieldId) throws Exception{
		logger.trace("replaceEntryValueWithId method with oldValue "+oldValue+" newId "+newId+" fieldId "+fieldId);
		DBSession session= DBSession.connect();
		try{
			Select selectQuery= DBSession.getImplementation(Select.class);
			selectQuery.setAttributes(new SimpleAttribute(this.keyId));
			CastObject idCast= Utility.getCast(newId, this.codeTypeInDimension);
			selectQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(this.codeFieldIdInDimension),idCast,"="));
			selectQuery.setTables(this.dimensionTable);

			logger.trace(selectQuery.getExpression());
			ResultSet selectQueryRS=selectQuery.getResults(session);

			if (selectQueryRS.next()) {
				String newValue=selectQueryRS.getString(1);
				logger.trace("new value is "+newValue);
				//this.valueSizeControl(newValue, this.keyType);
				try{

					ArrayList<Attribute> attributesToTake = cloneAttributeList();
					CastObject cast=Utility.getCast(newValue, keyType);
					attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), cast));
					attributesToTake.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast));
					
					CastObject castOldValue=Utility.getCast(oldValue, this.oldColumnType);

					//moving entries from wrong to correct
					Select modifiedEntriesQuery= DBSession.getImplementation(Select.class);
					
					modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0])); 
					modifiedEntriesQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), castOldValue, "="));
					modifiedEntriesQuery.setTables(getWrongsTable());

					//Insert modifiedEntries 
					InsertFromSelect insert=DBSession.getImplementation(InsertFromSelect.class);
					insert.setSubQuery(modifiedEntriesQuery);
					insert.setTable(getCorrectsTable());
					logger.trace(insert.getExpression());
					insert.execute(session);

					//UpdatingEntries in correctTable
					/*CastObject castNewValue=Utility.getCast(newValue, keyType);

					Update updateQuery= DBSession.getImplementation(Update.class);
					updateQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), castOldValue, "="));
					updateQuery.setOperators(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId+CurationResource.ID_COLUMN_SUFFIX), idCast, "="), new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), castNewValue, "="));
					updateQuery.setTable(getCorrectsTable());
					logger.trace(updateQuery.getExpression());
					updateQuery.execute(session);*/

					//Deleting entries from Wrong table
					Delete deleteQuery= DBSession.getImplementation(Delete.class);
					deleteQuery.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(fieldId), castOldValue, "="));
					deleteQuery.setTable(getWrongsTable());
					logger.trace(deleteQuery.getExpression());
					deleteQuery.execute(session);
				}catch(Exception e){logger.error("error replacing entries",e);}

			} else throw new ValueNotCompatibleFault();
		}finally{
			if (session!=null) session.release();
		}
	}
	
	private void insertCorretElementsTable(DBSession session, List<Attribute> curationTableAttributeToTake) throws Exception{
		final String TEMPORARY_DIMENSION_TABLE="tempdimtable";
		final String SELECTED_FIELD="selected_field";
		Select goodCellsCount= DBSession.getImplementation(Select.class);
		goodCellsCount.setTables(this.dimensionTable);
		goodCellsCount.setAttributes(new AssignedAttribute<AggregatedAttribute>(new SimpleAttribute(COUNT_ALIAS),new AggregatedAttribute("*",AggregationFunctions.COUNT)),
				new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(SELECTED_FIELD),new SimpleAttribute(keyId)));
		goodCellsCount.setGroups(new SimpleAttribute(SELECTED_FIELD));
		
		Select totalCorrectQuery= DBSession.getImplementation(Select.class);
		//CastObject idCast= Utility.getCast(new SimpleAttribute(ROW_ID_LABEL,TEMPORARY_DIMENSION_TABLE), new Type(Types.INTEGER, 8));
		
		List<Attribute> attributes= new ArrayList<Attribute>();
		attributes.addAll(curationTableAttributeToTake);
		attributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(this.fieldId+CurationResource.ID_COLUMN_SUFFIX),new SimpleAttribute(this.codeFieldIdInDimension,TEMPORARY_DIMENSION_TABLE)));
		totalCorrectQuery.setAttributes(attributes.toArray(new Attribute[0]));
		CastObject castFieldToText= Utility.getCastToString(new SimpleAttribute(fieldId,CURATION_TABLE_ALIAS));
		CastObject castSelectDimFieldToText = Utility.getCastToString(new SimpleAttribute(SELECTED_FIELD,DIMENSION_TABLE_ALIAS));
		totalCorrectQuery.setFilter(new ANDCondition(new OperatorCondition<Attribute, Attribute>(new SimpleAttribute(keyId, TEMPORARY_DIMENSION_TABLE), new SimpleAttribute(SELECTED_FIELD,DIMENSION_TABLE_ALIAS),"="), new OperatorCondition<CastObject, CastObject>(castFieldToText, castSelectDimFieldToText ,"=") , new OperatorCondition<Attribute,Integer>(new SimpleAttribute(COUNT_ALIAS,DIMENSION_TABLE_ALIAS),1,"=")));
		totalCorrectQuery.setTables(new Table(this.dimensionTable.getTableName(),TEMPORARY_DIMENSION_TABLE ), new Table(this.resourceTable.getTableName(),CURATION_TABLE_ALIAS), new TableFromSubselect(DIMENSION_TABLE_ALIAS,goodCellsCount));
		totalCorrectQuery.setUseDistinct(true);
		InsertFromSelect insertCorrect= DBSession.getImplementation(InsertFromSelect.class);
		insertCorrect.setSubQuery(totalCorrectQuery);
		insertCorrect.setTable(getCorrectsTable());
		logger.trace(insertCorrect.getExpression());
		insertCorrect.execute(session);
		logger.trace("the count for correct element is "+getCorrectsTable().getCount());
	}
	
	private void insertWrongElementsTable(DBSession session, List<Attribute> curationTableAttributeToTake) throws Exception{
		final String SELECTED_FIELD="selected_field";
		Select wrongCellsCount= DBSession.getImplementation(Select.class);
		wrongCellsCount.setTables(this.dimensionTable);
		wrongCellsCount.setAttributes(new AssignedAttribute<AggregatedAttribute>(new SimpleAttribute(COUNT_ALIAS),new AggregatedAttribute("*",AggregationFunctions.COUNT)),
				new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(SELECTED_FIELD),new SimpleAttribute(keyId)));
		wrongCellsCount.setGroups(new SimpleAttribute(SELECTED_FIELD));
		
		Select totalWrongQuery= DBSession.getImplementation(Select.class);
		List<Attribute> attributes= new ArrayList<Attribute>();
		attributes.addAll(curationTableAttributeToTake);
		attributes.add(new AssignedAttribute<CastObject>(new SimpleAttribute(this.fieldId+CurationResource.ID_COLUMN_SUFFIX),null));
		attributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(COUNT_ALIAS),new SimpleAttribute(COUNT_ALIAS,DIMENSION_TABLE_ALIAS)));
		totalWrongQuery.setAttributes(attributes.toArray(new Attribute[0]));
		CastObject castFieldToText= Utility.getCastToString(new SimpleAttribute(fieldId,CURATION_TABLE_ALIAS));
		CastObject castSelectDimFieldToText = Utility.getCastToString(new SimpleAttribute(SELECTED_FIELD,DIMENSION_TABLE_ALIAS));
		totalWrongQuery.setFilter(new ANDCondition(
				new OperatorCondition<CastObject, CastObject>(castFieldToText, castSelectDimFieldToText,"=") , 
				new OperatorCondition<Attribute,Integer>(new SimpleAttribute(COUNT_ALIAS,DIMENSION_TABLE_ALIAS),1,">")));
		totalWrongQuery.setTables(new Table(this.resourceTable.getTableName(),CURATION_TABLE_ALIAS), new TableFromSubselect(DIMENSION_TABLE_ALIAS,wrongCellsCount));
		
		InsertFromSelect insertWrongWithIds=DBSession.getImplementation(InsertFromSelect.class);
		insertWrongWithIds.setSubQuery(totalWrongQuery);
		insertWrongWithIds.setTable(getWrongsTable());
		logger.trace(insertWrongWithIds.getExpression());
		insertWrongWithIds.execute(session);
		logger.trace("inserted value in wrong table (first part)");
		
		
		//selecting the wrong entries (without ids)
		Select withoutIdsWrongQuery= DBSession.getImplementation(Select.class);
		attributes= new ArrayList<Attribute>();
		attributes.addAll(curationTableAttributeToTake);
		attributes.add(new AssignedAttribute<Object>(new SimpleAttribute(this.fieldId+CurationResource.ID_COLUMN_SUFFIX),null));
		attributes.add(new AssignedAttribute<Integer>(new SimpleAttribute(COUNT_ALIAS), 0));
		withoutIdsWrongQuery.setAttributes(attributes.toArray(new Attribute[0]));
		withoutIdsWrongQuery.setTables(new Table(this.resourceTable.getTableName(),CURATION_TABLE_ALIAS));
		
		
		Select internalWrongQuery= DBSession.getImplementation(Select.class);
		CastObject castKeyFieldToText = Utility.getCastToString(new SimpleAttribute(this.keyId));
		internalWrongQuery.setAttributes(new SimpleAttribute(this.keyId));
		internalWrongQuery.setFilter(new OperatorCondition<CastObject, CastObject>(castFieldToText,castKeyFieldToText,"="));
		internalWrongQuery.setTables(this.dimensionTable);
		withoutIdsWrongQuery.setFilter(new OperatorCondition<SimpleAttribute, Select>(internalWrongQuery,"NOT EXISTS"));
		
		//inserting wrong without ids
		InsertFromSelect insertWrongWithoutIds=DBSession.getImplementation(InsertFromSelect.class);
		insertWrongWithoutIds.setSubQuery(withoutIdsWrongQuery);
		insertWrongWithoutIds.setTable(getWrongsTable());
		logger.trace(insertWrongWithoutIds.getExpression());
		insertWrongWithoutIds.execute(session);
		logger.trace("inserted value in wrong table (second part)");

	}

	/**
	 * 
	 * @return
	 */
	public List<ErrorPair> getDistinctErrors() throws Exception{
		Select select= DBSession.getImplementation(Select.class);
		select.setUseDistinct(true);
		select.setAttributes(new AggregatedAttribute("*", AggregationFunctions.COUNT), new SimpleAttribute(this.getFieldId()));
		select.setTables(getWrongsTable());
		select.setGroups(new SimpleAttribute(this.getFieldId()));
		DBSession session=DBSession.connect();
		List<ErrorPair> resultlist= new ArrayList<ErrorPair>();
		try{
			ResultSet result= select.getResults();
			while (result.next())
				resultlist.add(new ErrorPair(result.getInt(1), result.getString(2)));
		}finally{if (session!=null)session.release();}
		return resultlist;
	}
	
	/**
	 * checks how many errors there will be in edit mode for a specific dimension setting
	 * 
	 * @param dimensionId dimension id
	 * @param fieldId field id
	 * @param keyName key name
	 * @return the error count
	 * @throws Exception -
	 */
	public long check() throws Exception{
		DBSession session= DBSession.connect();
		try{
			
			final String curationTableAlias= "curtab";
			final String dimensionTableAlias="dimtab";
			final String countAlias="count";

			Select goodCellsCount= DBSession.getImplementation(Select.class);
			goodCellsCount.setAttributes(new AssignedAttribute<AggregatedAttribute>(new SimpleAttribute(countAlias),new AggregatedAttribute(keyId,AggregationFunctions.COUNT)), new SimpleAttribute(keyId));
			goodCellsCount.setTables(dimensionTable);
			goodCellsCount.setGroups(new SimpleAttribute(keyId));

			Select totalCorrectCount= DBSession.getImplementation(Select.class);
			totalCorrectCount.setAttributes(new AggregatedAttribute("*",AggregationFunctions.COUNT));
			CastObject fieldCastToString = Utility.getCastToString(new SimpleAttribute(fieldId,curationTableAlias)); 
			CastObject dimCastToString =Utility.getCastToString(new SimpleAttribute(keyId,dimensionTableAlias));
			totalCorrectCount.setFilter(new ANDCondition( new OperatorCondition<CastObject, CastObject>(fieldCastToString, dimCastToString,"=") , 
					new OperatorCondition<Attribute,Integer>(new SimpleAttribute(countAlias,dimensionTableAlias),1,"=")));
			totalCorrectCount.setTables(new Table(this.resourceTable.getTableName(),curationTableAlias), new TableFromSubselect(dimensionTableAlias,goodCellsCount));

			logger.trace(totalCorrectCount.getExpression());
			ResultSet totalCorrectRes=totalCorrectCount.getResults(session);
			totalCorrectRes.next();
			this.resourceTable.initializeCount(session);
			long size= this.resourceTable.getCount()-totalCorrectRes.getLong(1);
			logger.debug("the dimension check count is "+size);		
			return size;
		}finally{
			session.release();
		}
	}
	
	
	/**
	 * @return the dimensionTable
	 */
	public SimpleTable getDimensionTable() {
		return dimensionTable;
	}

	@Override
	public void replaceValue(int rowId, Object value) throws Exception {
		throw new OperationNotSupportedException();
	}
	
	
	
	
	
	//TODO:REMOVE IT when the RD will be synchronized with portlet
	private String toJSon(ResultSet resultSet) throws SQLException
	{
		StringBuilder json = new StringBuilder();
		json.append("{\"response\":{\"value\":{\"items\":[");
		ResultSetMetaData metaData = resultSet.getMetaData();
		int numberOfColumns = metaData.getColumnCount();
		int count = 0;
		while(resultSet.next()){
			if (count>0) json.append(",{");
			else json.append('{');
			for (int column = 1; column <=numberOfColumns; column++){
				if (column>1) json.append(',');
				json.append(quote(metaData.getColumnName(column)));
				json.append(':');
				json.append(quote(resultSet.getString(column)));
			}
			json.append('}');
			count++;
		}
		json.append("],\"total_count\":"+count);
		json.append(",\"version\":1}}}");
		return json.toString();
	}
	
	//TODO:REMOVE IT when the RD will be synchronized with portlet
	private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char         b;
        char         c = 0;
        int          i;
        int          len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        String       t;
        sb.append('"');
        for (i = 0; i < len; i += 1) {
            b = c;
            c = string.charAt(i);
            switch (c) {
            case '\\':
            case '"':
                sb.append('\\');
                sb.append(c);
                break;
            case '/':
                if (b == '<') {
                    sb.append('\\');
                }
                sb.append(c);
                break;
            case '\b':
                sb.append("\\b");
                break;
            case '\t':
                sb.append("\\t");
                break;
            case '\n':
                sb.append("\\n");
                break;
            case '\f':
                sb.append("\\f");
                break;
            case '\r':
                sb.append("\\r");
                break;
            default:
                if (c < ' ' || (c >= '\u0080' && c < '\u00a0') ||
                               (c >= '\u2000' && c < '\u2100')) {
                    t = "000" + Integer.toHexString(c);
                    sb.append("\\u" + t.substring(t.length() - 4));
                } else {
                    sb.append(c);
                }
            }
        }
        sb.append('"');
        return sb.toString();
    }
	
	
	public String getPossibleValues(String word) throws Exception{
			
		logger.trace("running the suggest word method");
			
		CategoryGuesser guesser = new CategoryGuesser((String)ServiceContext.getContext().getProperty("configDir", true));
		
		//guesser.initSingleMatcher(ServiceContext.getContext().getPossibleValueRetrieverConfiguration(), this.getDimensionTableNameHuman());
				
		guesser.runGuesser(word, ServiceContext.getContext().getPossibleValueRetrieverConfiguration(), this.getDimensionTableNameHuman(), this.getKeyId());
		
		ArrayList<SingleResult> results = guesser.getDetailedMatches();
		
		logger.trace("initliazed LexicalEngine and get back "+results.size()+" results");
		
		List<String> listWords= new ArrayList<String>();
		for (SingleResult res: results)
			listWords.add(res.getCategory());
		Select retrieveDimensionRow= DBSession.getImplementation(Select.class);
		retrieveDimensionRow.setAttributes(SimpleAttribute.ALL);
		retrieveDimensionRow.setFilter(new IsInOperator(new SimpleAttribute(this.getKeyId()), new StringArray(listWords)));
		retrieveDimensionRow.setTables(this.getDimensionTable());
		DBSession session = null;
		ResultSet toReturn;
		String json;
		try{
			session = DBSession.connect();
			logger.debug("possible value is "+retrieveDimensionRow.getExpression());
			toReturn = retrieveDimensionRow.getResults(session);
			json = toJSon(toReturn);
		}finally{
			if (session!=null) session.release();
		}
		return json;
	}

	@Override
	public org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition getTemporaryColumnDefinition(org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition oldColumnDefinition) throws Exception {
		org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition definition = new org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition();
		definition.setId(this.fieldId);
		definition.setDimensionRelatedFieldId(this.getFieldId()+CurationResource.ID_COLUMN_SUFFIX);
		definition.setColumnType(EntryType.Dimension);
		definition.setDimension(new Dimension(this.getCodelistId(),null,this.getDimensionTableNameHuman()));
		definition.setKey(new Key(this.getKeyId(), this.keyName, Util.mapSqlToJava(this.getKeyType().getType())));
		definition.setValueType(Util.mapSqlToJava(this.keyType.getType()));
		definition.setLabel(oldColumnDefinition.getLabel());
		return definition;
	}

	private ArrayList<Attribute> cloneAttributeList() throws Exception {
		ArrayList<Attribute> toReturn = new ArrayList<Attribute>();
		for (Attribute attrib : this.attributesList)
			toReturn.add(attrib);
		return toReturn;
	}
	
}
	

