package org.gcube.contentmanagement.timeseriesservice.impl.curation.rules;

import java.io.Serializable;
import java.util.Iterator;

import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;

@TableRootDefinition
public class Rule extends ObjectStateControl implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -146515956046723087L;

	private static transient GCUBELog logger = new GCUBELog(Rule.class);
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
	private String id;
	
	@FieldDefinition(precision={80},specifications={Specification.NOT_NULL})
	private String name;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String description;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String humanReadable;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private FilterCondition filter;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private  Types type;
	
	@SuppressWarnings("unused")
	private Rule(){}

	public Rule(String name, String description,
			String humanReadable, FilterCondition filter, Types type) {
		super();
		this.id = UUIDGenFactory.getUUIDGen().nextUUID();
		this.name = name;
		this.description = description;
		this.humanReadable = humanReadable;
		this.filter = filter;
		this.type = type;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the humanReadable
	 */
	public String getHumanReadable() {
		return humanReadable;
	}

	
	
	/**
	 * @return the type
	 */
	public Types getType() {
		return type;
	}

	/**
	 * @return the filter
	 */
	public FilterCondition getFilter() {
		return filter;
	}
	
	public boolean store(){
		try{
			ObjectPersistency<Rule> op = ObjectPersistency.get(Rule.class);
			if (!op.existsKey(this.getId()))
				op.insert(this);
			else op.update(this);
		}catch (Exception e) {
			logger.error("error storing on DB",e);
			return false;
		}
		return true;
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public  static  Iterator<Rule> getAll() throws Exception{
		return ObjectPersistency.get(Rule.class).getAll().iterator();
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public  static  Iterator<Rule> getByType(Types type) throws Exception{
		return ObjectPersistency.get(Rule.class).getObjectByField("type", type.toString()).iterator();
	}
	
	/**
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public static Rule get(String id) throws Exception{
		return ObjectPersistency.get(Rule.class).getByKey(id);
	}
	
	/**
	 * 
	 * @param id
	 * @throws Exception
	 */
	public static void destroy(String id) throws Exception{
		ObjectPersistency.get(Rule.class).deleteByKey(id);
	}

	
}
