package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.entities.TableField.ColumnType;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupElement;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class Grouping extends Operation{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7898279780075627851L;

	private static GCUBELog logger= new GCUBELog(Grouping.class);
	
	private AggregationFunction aggregationFuncion;
	private GroupElement[] groupList;
	
	public Grouping(){
		super();
		this.type= OperationType.Grouping;
		this.viewName="g"+uuidGen.nextUUID().replaceAll("-","");
	}
	
	@Override
	public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
		Map<String, GroupingEntry> groupingMap= new HashMap<String, GroupingEntry>();

		
		
		for (GroupElement gElement:groupList){
			String fieldIdToGroup=gElement.getFieldIdToGroup();
			String childDimensionId=getColumnDefinitionReference(fieldIdToGroup,previousTableDefinition).getDimension().getId();
			logger.trace("parent is: "+gElement.getParentReferenceId()+" child is "+childDimensionId+" and field id is "+fieldIdToGroup);
			
			Iterator<CodeList> codeListIt = CodeList.getByType(CodeListType.Hierarchical);
			String relationTableName = null;
			String childField = null, parentField = null, parentCodeField = null;
			while (codeListIt.hasNext()){
				boolean childCodeFound = false, parentCodeFound = false; 
				CodeList codelist = codeListIt.next();
				logger.debug("retrieved codelist "+codelist.getId()+" "+codelist.getName()+" "+childDimensionId+" "+gElement.getParentReferenceId());
				for (TableField tf : codelist.getLabelFieldMapping().values()){
					if (tf.getColumnReference().getType()== ColumnType.HLChildCode && tf.getColumnReference().getCodelistReferenceId().equals(childDimensionId)){
						childCodeFound = true;
						childField = tf.getId();
					}
					if (tf.getColumnReference().getType()== ColumnType.HLParentCode && tf.getColumnReference().getCodelistReferenceId().equals(gElement.getParentReferenceId())){
						parentCodeFound = true;
						parentField = tf.getId();
					}
				}
				if (childCodeFound && parentCodeFound) {
					relationTableName = codelist.getTable().getTableName();
					break;
				}
			}
			
			if (relationTableName==null) throw new Exception("impossible to retrieve the relation");
			CodeList parentCodelist;
			try{
				parentCodelist = CodeList.get(gElement.getParentReferenceId());
			} catch(ObjectNotFoundException e){
				logger.error("impossible to retrieve the references", e);
				throw new Exception("impossible to retrieve the references");
			}
			
			String parentTableName=parentCodelist.getTable().getTableName();
			String parentNameHuman=parentCodelist.getName();

			SimpleTable parentTable= parentCodelist.getTable();
			
			parentCodeField = parentCodelist.getCodeColumnId();
			
			Type parentKeyType= parentTable.getFieldsMapping().get(gElement.getParentReferenceKeyName());
			if (parentKeyType == null) throw new Exception("the key "+gElement.getParentReferenceKeyName()+" is not found");
			//Object[] groupObject = new Object[]{relationTableName, parentTableName, gElement.getParentReferenceKeyName(), gElement.getParentReferenceId(),parentNameHuman,parentKeyType};
			
			groupingMap.put(fieldIdToGroup, new GroupingEntry(relationTableName, parentTableName, gElement.getParentReferenceKeyName(), gElement.getParentReferenceId(),parentNameHuman,parentKeyType, childField, parentField, parentCodeField));
		}

		final String RESOURCE_TABLE_ALIAS="ts";
		ArrayList<ColumnDefinition> newColumnDefinition= new ArrayList<ColumnDefinition>();
		List<Attribute> selectAttributes= new ArrayList<Attribute>();
		List<SimpleAttribute> groupAttributes= new ArrayList<SimpleAttribute>();
		List<Condition> whereConditions= new ArrayList<Condition>();
		Set<Table> tables= new HashSet<Table>();
		tables.add(new Table(previuosTableName,RESOURCE_TABLE_ALIAS));
		for (ColumnDefinition def: previousTableDefinition){
			if (def.getColumnType()==EntryType.Dimension){
				GroupingEntry groupDef;
				if ((groupDef=groupingMap.get(def.getId()))!=null){
					selectAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(def.getId()),new SimpleAttribute(groupDef.getParentReferenceKeyName(),groupDef.getParentTableName())));
					selectAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(def.getDimensionRelatedFieldId()), new SimpleAttribute(groupDef.getParentCodeFieldId(),groupDef.getParentTableName())));
					tables.add(new Table(groupDef.getParentTableName()));
					tables.add(new Table(groupDef.getRelationTableName()));
					CastObject childCast= DBSession.getImplementation(CastObject.class);
					childCast.setField(new SimpleAttribute(groupDef.getChildFieldId(),groupDef.getRelationTableName()));
					childCast.setType(new Type(Types.INTEGER));
														
					whereConditions.add(new ANDCondition(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(def.getDimensionRelatedFieldId(),RESOURCE_TABLE_ALIAS),childCast,"="),
							new OperatorCondition<SimpleAttribute, SimpleAttribute>(new SimpleAttribute(groupDef.getParentCodeFieldId(),groupDef.getParentTableName()) ,new SimpleAttribute(groupDef.getParentFieldId(),groupDef.getRelationTableName()),"=")));
					
					String keyName = CodeList.get(groupDef.getParentReferenceId()).getLabelFieldMapping().get(groupDef.getParentReferenceKeyName()).getFieldName();
					Key key= new Key(groupDef.getParentReferenceKeyName(), keyName,  Util.mapSqlToJava(groupDef.getParentKeyType().getType()));
					Dimension dimension = new Dimension(groupDef.getParentReferenceId(),null, groupDef.getParentNameHuman());
					newColumnDefinition.add(
							new ColumnDefinition(EntryType.Dimension,
									dimension, def.getDimensionRelatedFieldId(),
									def.getId(), key, def.getLabel(),null));
					//adding grouping attributes for selected key and id
					groupAttributes.add(new SimpleAttribute(groupDef.getParentReferenceKeyName(),groupDef.getParentTableName()));
					groupAttributes.add(new SimpleAttribute(groupDef.getParentCodeFieldId(),groupDef.getParentTableName()));
				}else{
					selectAttributes.add(new SimpleAttribute(def.getId(),RESOURCE_TABLE_ALIAS));
					selectAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(),RESOURCE_TABLE_ALIAS));
					groupAttributes.add(new SimpleAttribute(def.getId(),RESOURCE_TABLE_ALIAS));
					groupAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(),RESOURCE_TABLE_ALIAS));
					newColumnDefinition.add(def);
				}
			}else if (def.getColumnType()==EntryType.Value){
				selectAttributes.add(new AssignedAttribute<AggregatedAttribute>(new SimpleAttribute(def.getId()), new AggregatedAttribute(def.getId(), RESOURCE_TABLE_ALIAS , AggregationFunctions.valueOf(this.aggregationFuncion.getValue()))));
				newColumnDefinition.add(def);
			}else {
				selectAttributes.add(new SimpleAttribute(def.getId(),RESOURCE_TABLE_ALIAS));
				groupAttributes.add(new SimpleAttribute(def.getId(),RESOURCE_TABLE_ALIAS));
				newColumnDefinition.add(def);
			}
		}
		setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));

		Select query= DBSession.getImplementation(Select.class);
		query.setAttributes(selectAttributes.toArray(new Attribute[0]));
		query.setFilter(new ANDCondition(whereConditions.toArray(new Condition[0])));
		query.setTables(tables.toArray(new Table[0]));
		query.setGroups(groupAttributes.toArray(new SimpleAttribute[0]));
		this.createTable(query, session, false);
		
		InsertFromSelect insertGroupTable=DBSession.getImplementation(InsertFromSelect.class);
		insertGroupTable.setTable(this.viewTable);
		insertGroupTable.setSubQuery(query);

		logger.trace("table created with query: "+insertGroupTable.getExpression());
		insertGroupTable.execute(session);
		//changeColumnId();

		setCount(this.viewTable.getCount());

		//History Item creation
		String groupedFields=" ";
		for (GroupElement field: this.groupList)
			groupedFields+=getColumnDefinitionReference(field.getFieldIdToGroup(), previousTableDefinition).getLabel()+" ";		
		setHistoryItem(new TSHistoryItem("TO DO","grouped fields ["+groupedFields+"]  applying function "+this.aggregationFuncion,new Date(),OperationType.Grouping));

		logger.trace("count calculated in "+getCount());
		logger.trace("grouping intialization finished");
	}

	@Override
	public void setParameters(Object... parameters) throws Exception {
		GroupRequest request= (GroupRequest) parameters[0];
		this.aggregationFuncion= request.getAggregateFunction();
		this.groupList= request.getGroupingList();
	}

	private class GroupingEntry{
		
		String relationTableName;
		String parentTableName;
		String parentReferenceKeyName;
		String parentReferenceId;
		String parentNameHuman;
		String childFieldId;
		String parentFieldId;
		Type parentKeyType;
		String parentCodeFieldId;
		
		public GroupingEntry(String relationTableName, String parentTableName,
				String parentReferenceKeyName, String parentReferenceId,
				String parentNameHuman, Type parentKeyType, String childFieldId,
				String parentFieldId, String parentCodeFieldId) {
			super();
			this.relationTableName = relationTableName;
			this.parentTableName = parentTableName;
			this.parentReferenceKeyName = parentReferenceKeyName;
			this.parentReferenceId = parentReferenceId;
			this.parentNameHuman = parentNameHuman;
			this.parentKeyType = parentKeyType;
			this.childFieldId = childFieldId;
			this.parentFieldId = parentFieldId;
			this.parentCodeFieldId = parentCodeFieldId;
			
		}
		/**
		 * @return the relationTableName
		 */
		public String getRelationTableName() {
			return relationTableName;
		}
		/**
		 * @return the parentTableName
		 */
		public String getParentTableName() {
			return parentTableName;
		}
		/**
		 * @return the parentReferenceKeyName
		 */
		public String getParentReferenceKeyName() {
			return parentReferenceKeyName;
		}
		/**
		 * @return the parentReferenceId
		 */
		public String getParentReferenceId() {
			return parentReferenceId;
		}
		/**
		 * @return the parentNameHuman
		 */
		public String getParentNameHuman() {
			return parentNameHuman;
		}
		/**
		 * @return the parentKeyType
		 */
		public Type getParentKeyType() {
			return parentKeyType;
		}
		/**
		 * @return the childFieldId
		 */
		public String getChildFieldId() {
			return childFieldId;
		}
		/**
		 * @return the parentFieldId
		 */
		public String getParentFieldId() {
			return parentFieldId;
		}
		/**
		 * @return the parentCodeFieldId
		 */
		public String getParentCodeFieldId() {
			return parentCodeFieldId;
		}
		
		
		
	}
	
}
