package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;

/**
 * 
 * @author lucio
 *
 */
public class InsertDenomalizedT extends InsertThread {
		
	private boolean[] attributesFieldMask;
	private String attributeLabel;
	private String valueLabel;
	
	
	public InsertDenomalizedT(String rslocator, String tableName,
			boolean hasHeader, char delimiter, String encoding, boolean[] fieldsMask,
			final boolean[] attributesFieldMask, String attributeLabel, String valueLabel, ImporterItem importer) {
		super(rslocator, tableName, fieldsMask,
				hasHeader, delimiter, encoding, importer);
		this.attributeLabel= attributeLabel;
		this.valueLabel= valueLabel;
		this.attributesFieldMask= attributesFieldMask;		
	}
	

	@Override
	public void execute(CSVReaderProcessor processor, File fileStream)
			throws Exception {
		logger.trace("starting denormalized import");
		if (!this.hasHeader) throw new Exception("denormalized csv import MUST contain header");
		final List<String> fieldSetTmp= new ArrayList<String>();
		final List<ColumnDefinition> tableDefinition=new ArrayList<ColumnDefinition>(); 
		final List<String> attributesLabels= new ArrayList<String>();
		
		//precalculating the table definition
		processor.processStream( new InputStreamReader(new FileInputStream(fileStream), this.encoding), new LineProcessor(){
			public void processDataLine(int lineNumber, List<String> fields) {
				processInitializationDataLine(lineNumber, fields, tableDefinition);
				totalEntries=lineNumber;
			}	
			public void processHeaderLine(int lineNumber, List<String> fields) {
				columnDefinitionCreation(fields, fieldSetTmp, tableDefinition, attributesLabels);
			}});
		
		
		
		//if (columnsNumber!=this.fieldsMask.length) throw new Exception("the fieldMask size is different respect the field number");
		
		//if (columnsNumber!=this.attributesFieldMask.length) throw new Exception("the attribute Mask size is different respect the field number");
				
		int attributesNumber=0;
		int fieldSelected=0;
		for (int i=0; i < attributesFieldMask.length; i++){
			if (attributesFieldMask[i]) attributesNumber++;
			if (fieldsMask[i]) fieldSelected++;
		}
		if (this.hasHeader) totalEntries--;
		
		//if (columnsNumber!=this.attributesFieldMask.length) throw new Exception("the attribute Mask size is different respect the field number");
		
		logger.trace("the column number is "+columnsNumber+" and the selected field are  "+fieldSelected+" ant the attributes are "+attributesNumber);
		
		importer.setExstimatedLines(totalEntries*attributesNumber);
		
		logger.trace("extimated lines are "+(totalEntries*attributesNumber));
		
		importer.setFieldNames(fieldSetTmp);

		logger.trace("creating table "+this.tableName+" with "+tableDefinition.size()+" fields");
		SimpleTable table= createTable(tableDefinition);
		final Insert insertValues= DBSession.getImplementation(Insert.class);
		insertValues.setTable(table);
		
		//resetting total entries to calculate import progress
		totalEntries=0;
				
		processor.processStream(new InputStreamReader(new FileInputStream(fileStream), this.encoding), new LineProcessor(){
			public void processDataLine(int lineNumber, List<String> fields){
				//logger.trace("processing data line "+lineNumber);
				insertingProcess(lineNumber, fields, insertValues, attributesLabels);
			}
			
			public void processHeaderLine(int LineNumber, List<String> fields){}
		});
		
		Map<String, int[]> fieldLenght= new HashMap<String, int[]>();
		//TODO: check : the id should be discarded here ?
		for (int i=1;i<tableDefinition.size(); i++)
			fieldLenght.put("field"+(i-1), tableDefinition.get(i).getType().getPrecisionArray());

		importer.setTotalLines(totalEntries);
		importer.setTable(table);

		getResource().setFieldLenght(fieldLenght);
		getResource().setTable(table);
		
	}
	
	
	/**
	 * 
	 * @param lineNumber
	 * @param fields
	 * @param insertValues
	 */
	final private void insertingProcess(int lineNumber, List<String> fields,Insert insertValues, List<String> attributesLabels){
		try{
			//logger.trace("function inserting process at line "+lineNumber);
			List<Object> selectedValues= new ArrayList<Object>();
			selectedValues.add("DEFAULT");
			int[] orderedAttributesValue= new int[attributesLabels.size()];
			int attributeIndex=0;
			for (int i=0; i<fields.size(); i++)
				if(fieldsMask[i] & !attributesFieldMask[i]) selectedValues.add(fields.get(i)!=null?fields.get(i):"");
				else if (attributesFieldMask[i])
					orderedAttributesValue[attributeIndex++]=i;
				
			//logger.trace("selected values for line "+lineNumber+" are "+selectedValues.size());
			for (int i=0; i<orderedAttributesValue.length; i++){
				try{
					//logger.trace("inserting attribute "+i+" and line "+lineNumber);
					List<Object> objectList = new ArrayList<Object>();
					objectList.addAll(selectedValues);
					objectList.add(attributesLabels.get(i));
					objectList.add(fields.get(orderedAttributesValue[i]));
					//logger.trace(Arrays.toString(objectList.toArray(new Object[objectList.size()])));
					insertValues.setInsertValues(objectList.toArray(new Object[objectList.size()]));
					insertValues.execute(session);
					totalEntries++;
				}catch (Exception e) {
					logger.error("error inserting value",e);
				}
			}
		} catch (Exception e) {
			logger.debug("error inserting values",e);
		}
		importer.setImportProgress(totalEntries);
	}
	
	
	final private void columnDefinitionCreation(List<String> fieldsLabel, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition, List<String> attributesLabels){
		try{
			tableDefinition.add(Utility.getColumnDefinition("id", new Type(Types.INTEGER,8), Specification.NOT_NULL, Specification.AUTO_INCREMENT ));
			int k=0;
			columnsNumber= 0;
			int attributeMaxLength =-1;
			int attributeMaxDotLength = 0;
			for (int i=0; i<fieldsLabel.size(); i++){
				if(fieldsMask[i] & !attributesFieldMask[i]){
					//logger.debug("the max for field"+(k)+" is "+fields.size());
					tableDefinition.add(Utility.getColumnDefinition("field"+k, new Type(Types.STRING,1,0)));
					if (fieldsLabel!=null && fieldsLabel.get(i)!="") fieldSetTmp.add(fieldsLabel.get(i)); 
					else fieldSetTmp.add("field"+k);
					columnsNumber++;
					k++;
				} 
				//saving the attributes labels
				else if (attributesFieldMask[i]){
					if (attributeMaxLength<fieldsLabel.get(i).length()) attributeMaxLength= fieldsLabel.get(i).length() ;
					int templength=0;
					if ((templength = ImportUtil.getAfterDotLength(fieldsLabel.get(i)))>attributeMaxDotLength) attributeMaxDotLength = templength;
					attributesLabels.add(fieldsLabel.get(i)); 				
				}
			}
			//adding the attribute column
			tableDefinition.add(Utility.getColumnDefinition("field"+k, new Type(Types.STRING,attributeMaxLength,attributeMaxDotLength)));
			fieldSetTmp.add(attributeLabel);
			//adding the value column
			tableDefinition.add(Utility.getColumnDefinition("field"+(k+1), new Type(Types.STRING,1,0)));
			fieldSetTmp.add(valueLabel);
			columnsNumber+=2;
		}catch(Exception e){logger.error("error reading column definition",e);}
	}
		
	/**
	 * 
	 * @param lineNumber
	 * @param fields
	 * @param fieldSetTmp
	 * @param tableDefinition
	 */
	final private void processInitializationDataLine(int lineNumber, List<String> fields, List<ColumnDefinition> tableDefinition){
		if (fields.size()!=fieldsMask.length) return;
		try{
	
			int k=1;
			for (int i=0; i<fields.size(); i++){
				if(fieldsMask[i] & !attributesFieldMask[i]){
					//logger.debug("the max for field"+(k)+" is "+fields.size());
					if (fields.get(i).length()>tableDefinition.get(k).getType().getPrecisionArray()[0])
						tableDefinition.get(k).getType().getPrecisionArray()[0] = fields.get(i).length();
					int templength=0;
					if (( templength = ImportUtil.getAfterDotLength(fields.get(i)))>
								tableDefinition.get(k).getType().getPrecisionArray()[1])
							tableDefinition.get(k).getType().getPrecisionArray()[1]= templength;
					k++;
				}else if (attributesFieldMask[i]){
					if (fields.get(i).length()>tableDefinition.get(tableDefinition.size()-1).getType().getPrecisionArray()[0])
						tableDefinition.get(tableDefinition.size()-1).getType().getPrecisionArray()[0] = fields.get(i).length();
					int templength=0;
					if (( templength = ImportUtil.getAfterDotLength(fields.get(i)))>
								tableDefinition.get(tableDefinition.size()-1).getType().getPrecisionArray()[1])
							tableDefinition.get(tableDefinition.size()-1).getType().getPrecisionArray()[1]= templength;
				}
			}
			
			
		}catch(Exception e){logger.error("error reading lines", e);}
	}
}