package org.gcube.contentmanagement.timeseriesservice.impl.history;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;

@TableRootDefinition
public class TSHistory implements Serializable{

	//public static final String HISTORY_TABLE="TSHistoryTable";
	//public static final String HISTORY_PREF="HT";
	
	//private static final GCUBELog logger= new GCUBELog(TSHistory.class);
	
	/**
	 * 	
	 * @param id
	 * @param curParentId
	 * @param historyCreationDate
	 * @param itemLimit
	 * @param parentName
	 * @param author
	 */
	public TSHistory(String id, String curParentId, Date historyCreationDate, int itemLimit, String parentTitle, String author) {
		super();
		this.historyList = null;
		this.parentType = ParentType.CUR;
		this.parentId = curParentId;
		this.itemLimit= itemLimit;
		this.historyCreationDate= historyCreationDate;
		this.id=id;
		this.parentName= parentTitle;
		this.author= author;
	}

	/**
	 * 
	 * @param id
	 * @param tsParentId
	 * @param historyCreationDate
	 * @param parentName
	 * @param author
	 */
	public TSHistory(String id, String tsParentId, Date historyCreationDate,String parentTitle, String author) {
		super();
		this.historyList = new LinkedList<TSHistoryItem>();
		this.parentType = ParentType.TS;
		this.parentId = tsParentId;
		this.historyCreationDate= historyCreationDate;
		this.id=id;
		this.parentName= parentTitle;
		this.itemLimit=0;
		this.author= author;
	}

	@SuppressWarnings("unused")
	private TSHistory(){}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 7515773534337438628L;

	@FieldDefinition()
	private LinkedList<TSHistoryItem> historyList;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	private Date historyCreationDate; 
	
	@FieldDefinition(precision={200},specifications={Specification.NOT_NULL})
	private String parentName;
	
	@FieldDefinition(precision={200},specifications={Specification.NOT_NULL})
	private String author;
	
	public enum ParentType{TS,CUR};
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	public int itemLimit;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	private ParentType parentType;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	private String parentId;

	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
	private String id;
	
	public LinkedList<TSHistoryItem> getHistoryList() {
		return historyList;
	}

	protected void setHistoryList(LinkedList<TSHistoryItem> historyList) {
		this.historyList = historyList;
	}

	public ParentType getParentType() {
		return parentType;
	}

	public void setParentType(ParentType parentType) {
		this.parentType = parentType;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	
	public void addHistoryItems(TSHistoryItem item){
		this.historyList.add(item);
	}
	
	public void removeAllHistoryItems(List<TSHistoryItem> items){
		this.historyList= new LinkedList<TSHistoryItem>();
	}

	public Date getHistoryCreationDate() {
		return historyCreationDate;
	}

	public void setHistoryCreationDate(Date historyCreationDate) {
		this.historyCreationDate = historyCreationDate;
	}

	public String getId() {
		return id;
	}
	
	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}
	
	public int getItemLimit() {
		return itemLimit;
	}

	public void setItemLimit(int itemLimit) {
		this.itemLimit = itemLimit;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	public void store() throws Exception{
		ObjectPersistency<TSHistory> op = ObjectPersistency.get(TSHistory.class);
		if (!op.existsKey(this.getId()))
			op.insert(this);
		else op.update(this);
	}
	
	/**
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public static TSHistory retrieveHistory(String id) throws Exception{
		return ObjectPersistency.get(TSHistory.class).getByKey(id);
	}
	
	
		
}
