/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupElement;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class Grouping
extends Operation {
    private static final long serialVersionUID = -7898279780075627851L;
    private static GCUBELog logger = new GCUBELog(Grouping.class);
    private AggregationFunction aggregationFuncion;
    private GroupElement[] groupList;

    public Grouping() {
        this.type = OperationType.Grouping;
        this.viewName = "g" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        Object parentField;
        HashMap<String, GroupingEntry> groupingMap = new HashMap<String, GroupingEntry>();
        GroupElement[] groupElementArray = this.groupList;
        int n = this.groupList.length;
        int n2 = 0;
        while (n2 < n) {
            CodeList parentCodelist;
            GroupElement gElement = groupElementArray[n2];
            String fieldIdToGroup = gElement.getFieldIdToGroup();
            String childDimensionId = Grouping.getColumnDefinitionReference(fieldIdToGroup, previousTableDefinition).getDimension().getId();
            logger.trace((Object)("parent is: " + gElement.getParentReferenceId() + " child is " + childDimensionId + " and field id is " + fieldIdToGroup));
            Iterator codeListIt = CodeList.getByType((CodeListType)CodeListType.Hierarchical);
            String relationTableName = null;
            String childField = null;
            parentField = null;
            String parentCodeField = null;
            while (codeListIt.hasNext()) {
                boolean childCodeFound = false;
                boolean parentCodeFound = false;
                CodeList codelist = (CodeList)codeListIt.next();
                logger.debug((Object)("retrieved codelist " + codelist.getId() + " " + codelist.getName() + " " + childDimensionId + " " + gElement.getParentReferenceId()));
                for (TableField tf : codelist.getLabelFieldMapping().values()) {
                    if (tf.getColumnReference().getType() == TableField.ColumnType.HLChildCode && tf.getColumnReference().getCodelistReferenceId().equals(childDimensionId)) {
                        childCodeFound = true;
                        childField = tf.getId();
                    }
                    if (tf.getColumnReference().getType() != TableField.ColumnType.HLParentCode || !tf.getColumnReference().getCodelistReferenceId().equals(gElement.getParentReferenceId())) continue;
                    parentCodeFound = true;
                    parentField = tf.getId();
                }
                if (!childCodeFound || !parentCodeFound) continue;
                relationTableName = codelist.getTable().getTableName();
                break;
            }
            if (relationTableName == null) {
                throw new Exception("impossible to retrieve the relation");
            }
            try {
                parentCodelist = CodeList.get((String)gElement.getParentReferenceId());
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)"impossible to retrieve the references", (Throwable)e);
                throw new Exception("impossible to retrieve the references");
            }
            String parentTableName = parentCodelist.getTable().getTableName();
            String parentNameHuman = parentCodelist.getName();
            SimpleTable parentTable = parentCodelist.getTable();
            parentCodeField = parentCodelist.getCodeColumnId();
            Type parentKeyType = (Type)parentTable.getFieldsMapping().get(gElement.getParentReferenceKeyName());
            if (parentKeyType == null) {
                throw new Exception("the key " + gElement.getParentReferenceKeyName() + " is not found");
            }
            groupingMap.put(fieldIdToGroup, new GroupingEntry(relationTableName, parentTableName, gElement.getParentReferenceKeyName(), gElement.getParentReferenceId(), parentNameHuman, parentKeyType, childField, (String)parentField, parentCodeField));
            ++n2;
        }
        String RESOURCE_TABLE_ALIAS = "ts";
        ArrayList<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
        ArrayList<Object> selectAttributes = new ArrayList<Object>();
        ArrayList<SimpleAttribute> groupAttributes = new ArrayList<SimpleAttribute>();
        ArrayList<ANDCondition> whereConditions = new ArrayList<ANDCondition>();
        HashSet<Table> tables = new HashSet<Table>();
        tables.add(new Table(previuosTableName, "ts"));
        parentField = previousTableDefinition;
        int childField = previousTableDefinition.length;
        int relationTableName = 0;
        while (relationTableName < childField) {
            ColumnDefinition def = parentField[relationTableName];
            if (def.getColumnType() == EntryType.Dimension) {
                GroupingEntry groupDef = (GroupingEntry)groupingMap.get(def.getId());
                if (groupDef != null) {
                    selectAttributes.add(new AssignedAttribute(new SimpleAttribute(def.getId()), (Object)new SimpleAttribute(groupDef.getParentReferenceKeyName(), groupDef.getParentTableName())));
                    selectAttributes.add(new AssignedAttribute(new SimpleAttribute(def.getDimensionRelatedFieldId()), (Object)new SimpleAttribute(groupDef.getParentCodeFieldId(), groupDef.getParentTableName())));
                    tables.add(new Table(groupDef.getParentTableName()));
                    tables.add(new Table(groupDef.getRelationTableName()));
                    CastObject childCast = (CastObject)DBSession.getImplementation(CastObject.class);
                    childCast.setField(new SimpleAttribute(groupDef.getChildFieldId(), groupDef.getRelationTableName()));
                    childCast.setType(new Type(Type.Types.INTEGER, new int[0]));
                    whereConditions.add(new ANDCondition(new Condition[]{new OperatorCondition((Object)new SimpleAttribute(def.getDimensionRelatedFieldId(), "ts"), (Object)childCast, "="), new OperatorCondition((Object)new SimpleAttribute(groupDef.getParentCodeFieldId(), groupDef.getParentTableName()), (Object)new SimpleAttribute(groupDef.getParentFieldId(), groupDef.getRelationTableName()), "=")}));
                    String keyName = ((TableField)CodeList.get((String)groupDef.getParentReferenceId()).getLabelFieldMapping().get(groupDef.getParentReferenceKeyName())).getFieldName();
                    Key key = new Key(groupDef.getParentReferenceKeyName(), keyName, Util.mapSqlToJava(groupDef.getParentKeyType().getType()));
                    Dimension dimension = new Dimension(groupDef.getParentReferenceId(), null, groupDef.getParentNameHuman());
                    newColumnDefinition.add(new ColumnDefinition(EntryType.Dimension, dimension, def.getDimensionRelatedFieldId(), def.getId(), key, def.getLabel(), null));
                    groupAttributes.add(new SimpleAttribute(groupDef.getParentReferenceKeyName(), groupDef.getParentTableName()));
                    groupAttributes.add(new SimpleAttribute(groupDef.getParentCodeFieldId(), groupDef.getParentTableName()));
                } else {
                    selectAttributes.add(new SimpleAttribute(def.getId(), "ts"));
                    selectAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(), "ts"));
                    groupAttributes.add(new SimpleAttribute(def.getId(), "ts"));
                    groupAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(), "ts"));
                    newColumnDefinition.add(def);
                }
            } else if (def.getColumnType() == EntryType.Value) {
                selectAttributes.add(new AssignedAttribute(new SimpleAttribute(def.getId()), (Object)new AggregatedAttribute(def.getId(), "ts", AggregationFunctions.valueOf((String)this.aggregationFuncion.getValue()))));
                newColumnDefinition.add(def);
            } else {
                selectAttributes.add(new SimpleAttribute(def.getId(), "ts"));
                groupAttributes.add(new SimpleAttribute(def.getId(), "ts"));
                newColumnDefinition.add(def);
            }
            ++relationTableName;
        }
        this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));
        Select query = (Select)DBSession.getImplementation(Select.class);
        query.setAttributes(selectAttributes.toArray(new Attribute[0]));
        query.setFilter((Condition)new ANDCondition(whereConditions.toArray(new Condition[0])));
        query.setTables(tables.toArray(new Table[0]));
        query.setGroups(groupAttributes.toArray(new SimpleAttribute[0]));
        this.createTable(query, session, false);
        InsertFromSelect insertGroupTable = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertGroupTable.setTable(this.viewTable);
        insertGroupTable.setSubQuery(query);
        logger.trace((Object)("table created with query: " + insertGroupTable.getExpression()));
        insertGroupTable.execute(session);
        this.setCount(this.viewTable.getCount());
        String groupedFields = " ";
        GroupElement[] groupElementArray2 = this.groupList;
        int n3 = this.groupList.length;
        int n4 = 0;
        while (n4 < n3) {
            GroupElement field = groupElementArray2[n4];
            groupedFields = String.valueOf(groupedFields) + Grouping.getColumnDefinitionReference(field.getFieldIdToGroup(), previousTableDefinition).getLabel() + " ";
            ++n4;
        }
        this.setHistoryItem(new TSHistoryItem("TO DO", "grouped fields [" + groupedFields + "]  applying function " + this.aggregationFuncion, new Date(), OperationType.Grouping));
        logger.trace((Object)("count calculated in " + this.getCount()));
        logger.trace((Object)"grouping intialization finished");
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        GroupRequest request = (GroupRequest)parameters[0];
        this.aggregationFuncion = request.getAggregateFunction();
        this.groupList = request.getGroupingList();
    }

    private class GroupingEntry {
        String relationTableName;
        String parentTableName;
        String parentReferenceKeyName;
        String parentReferenceId;
        String parentNameHuman;
        String childFieldId;
        String parentFieldId;
        Type parentKeyType;
        String parentCodeFieldId;

        public GroupingEntry(String relationTableName, String parentTableName, String parentReferenceKeyName, String parentReferenceId, String parentNameHuman, Type parentKeyType, String childFieldId, String parentFieldId, String parentCodeFieldId) {
            this.relationTableName = relationTableName;
            this.parentTableName = parentTableName;
            this.parentReferenceKeyName = parentReferenceKeyName;
            this.parentReferenceId = parentReferenceId;
            this.parentNameHuman = parentNameHuman;
            this.parentKeyType = parentKeyType;
            this.childFieldId = childFieldId;
            this.parentFieldId = parentFieldId;
            this.parentCodeFieldId = parentCodeFieldId;
        }

        public String getRelationTableName() {
            return this.relationTableName;
        }

        public String getParentTableName() {
            return this.parentTableName;
        }

        public String getParentReferenceKeyName() {
            return this.parentReferenceKeyName;
        }

        public String getParentReferenceId() {
            return this.parentReferenceId;
        }

        public String getParentNameHuman() {
            return this.parentNameHuman;
        }

        public Type getParentKeyType() {
            return this.parentKeyType;
        }

        public String getChildFieldId() {
            return this.childFieldId;
        }

        public String getParentFieldId() {
            return this.parentFieldId;
        }

        public String getParentCodeFieldId() {
            return this.parentCodeFieldId;
        }
    }
}

