/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.StringMap;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.TimeSeries;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state.TimeSeriesResource;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.OpenMsg;
import org.gcube.contentmanagement.timeseriesservice.stubs.ServiceMode;
import org.gcube.contentmanagement.timeseriesservice.stubs.ServiceProperties;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.globus.wsrf.ResourceKey;

public class TimeSeriesFactory {
    GCUBELog logger = new GCUBELog(TimeSeriesFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public CreateTsResponse create(CreateTsRequest request) throws GCUBEFault {
        CurationResource curationResource;
        this.logger.debug((Object)("trying to create TS " + request.getTitle()));
        String id = uuidGen.nextUUID();
        TimeSeriesResource resource = null;
        try {
            curationResource = (CurationResource)CurationContext.getPortTypeContext().getWSHome().find((ResourceKey)CurationContext.getPortTypeContext().makeKey(request.getRelatedCurationId()));
        }
        catch (Exception e) {
            this.logger.error((Object)"the Curation with selected Id does not exist", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"the Curation with selected Id does not exist"});
        }
        ColumnDefinition[] columnDefinitionArray = curationResource.getColumnDefinition();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            if (columnDefinition.getColumnType() == EntryType.Undefined) {
                this.logger.error((Object)"the selected curation resource is not completly defined");
                throw new GCUBEUnrecoverableFault(new String[]{"the selected curation resource is not completly defined"});
            }
            ++n2;
        }
        try {
            resource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().create(TimeSeriesContext.getPortTypeContext().makeKey(id), new Object[]{id, request, Boolean.TRUE});
            resource.store();
            return new CreateTsResponse(resource.getEPR(), resource.getId());
        }
        catch (Exception e) {
            if (resource != null) {
                resource.remove();
            }
            this.logger.error((Object)"error creating TS", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"error creating TS"});
        }
    }

    public CreateFromTsResponse createFromTs(CreateFromTsRequest request) throws GCUBEFault {
        this.logger.debug((Object)("trying to create TS " + request.getTitle() + " from " + request.getTsSourceId()));
        String id = uuidGen.nextUUID();
        try {
            TimeSeriesResource resource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().create(TimeSeriesContext.getPortTypeContext().makeKey(id), new Object[]{id, request, Boolean.FALSE});
            resource.store();
            return new CreateFromTsResponse(resource.getEPR(), resource.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)"error creating TS", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"error creating TS"});
        }
    }

    public EndpointReferenceType open(OpenMsg request) throws GCUBEFault {
        this.logger.debug((Object)("opening time series with Id " + request.getTsId()));
        GCUBEWSResourceKey timeSeriesKey = TimeSeriesContext.getPortTypeContext().makeKey(request.getTsId());
        EndpointReferenceType resourceEpr = null;
        TimeSeries ts = null;
        try {
            ts = (TimeSeries)ObjectPersistency.get(TimeSeries.class).getByKey((Object)request.getTsId());
            if (ts == null) {
                throw new Exception();
            }
            if (!ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope((String)ts.getScope()))) {
                throw new Exception();
            }
            if (!ts.getUsers().contains(" " + request.getUser() + " ")) {
                ts.setUsers(String.valueOf(ts.getUsers()) + ", " + request.getUser() + " ");
                ts.store();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"the requested timeSeries has been not found or has been created in a different scope");
            throw new GCUBEUnrecoverableFault(new String[]{"the requested timeSeries has been not found or has been created in a different scope"});
        }
        try {
            resourceEpr = TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)timeSeriesKey).getEPR();
        }
        catch (Exception nsre) {
            try {
                if (ts != null) {
                    ts.delete();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"error removing ts from timeseries table");
            }
            this.logger.error((Object)("the requested timeSeries " + request.getTsId() + " doesn't exist "), (Throwable)nsre);
            throw new GCUBEUnrecoverableFault(new String[]{"the requested timeSeries " + request.getTsId() + " doesn't exist"});
        }
        return resourceEpr;
    }

    public TimeSeriesItemsArray getImportedTimeSeries(String user) throws GCUBEFault {
        TimeSeriesItemsArray response = new TimeSeriesItemsArray();
        try {
            Iterator it = ObjectPersistency.get(TimeSeries.class).getObjectByField("published", (Object)false).iterator();
            this.logger.trace((Object)"retrieved imported items");
            ArrayList<TimeSeriesItem> listTimeSeries = new ArrayList<TimeSeriesItem>();
            while (it.hasNext()) {
                TimeSeries ts = (TimeSeries)it.next();
                if (!ts.getUsers().contains(" " + user + " ") && !ts.getCreator().equals(user) || !ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope((String)ts.getScope()))) continue;
                listTimeSeries.add(this.createTSItem(ts));
            }
            response.setItems(listTimeSeries.toArray(new TimeSeriesItem[listTimeSeries.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving imported Time Series", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"error retrieving imported Time Series"});
        }
        return response;
    }

    public TimeSeriesItemsArray getPublishedTimeSeries(VOID request) throws GCUBEFault {
        TimeSeriesItemsArray response = new TimeSeriesItemsArray();
        Object session = null;
        try {
            try {
                Iterator it = ObjectPersistency.get(TimeSeries.class).getObjectByField("published", (Object)true).iterator();
                ArrayList<TimeSeriesItem> listTimeSeries = new ArrayList<TimeSeriesItem>();
                while (it.hasNext()) {
                    TimeSeries ts = (TimeSeries)it.next();
                    if (!ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope((String)ts.getScope()))) continue;
                    listTimeSeries.add(this.createTSItem(ts));
                }
                response.setItems(listTimeSeries.toArray(new TimeSeriesItem[listTimeSeries.size()]));
            }
            catch (Exception e) {
                this.logger.error((Object)"error retrieving imported Time Series", (Throwable)e);
                throw new GCUBEUnrecoverableFault(e, new String[]{"error retrieving imported Time Series"});
            }
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return response;
    }

    public TimeSeriesItem getTimeSeriesInfoById(String tsId) throws Exception {
        TimeSeries ts;
        block3: {
            try {
                ts = (TimeSeries)ObjectPersistency.get(TimeSeries.class).getByKey((Object)tsId);
                if (ts != null) break block3;
                return null;
            }
            catch (Exception e) {
                this.logger.error((Object)"error retrieving imported Time Series", (Throwable)e);
                throw new GCUBEUnrecoverableFault(e, new String[]{"error retrieving imported Time Series"});
            }
        }
        return this.createTSItem(ts);
    }

    public VOID removeTimeSeries(String id) throws GCUBEFault {
        Object session = null;
        try {
            try {
                try {
                    ObjectPersistency.get(TimeSeries.class).deleteByKey((Object)id);
                }
                catch (Exception e) {
                    this.logger.error((Object)"error deleting entry in TimeSeries table, it's could be already deleted", (Throwable)e);
                }
                TimeSeriesContext.getPortTypeContext().getWSHome().remove((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(id));
            }
            catch (Exception e) {
                this.logger.error((Object)("error removing TimeSeries with id " + id), (Throwable)e);
                throw new GCUBEUnrecoverableFault(e, new String[0]);
            }
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return new VOID();
    }

    public ServiceProperties getServiceProperties(VOID req) throws GCUBEFault {
        try {
            ServiceProperties properties = new ServiceProperties();
            properties.setServiceMode(ServiceMode.fromValue((String)ServiceContext.getContext().getTsMode().toString()));
            properties.setProps(new StringMap(ServiceContext.getContext().getProperties()));
            return properties;
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting the serviceMode", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    private TimeSeriesItem createTSItem(TimeSeries ts) throws Exception {
        TimeSeriesItem tempItem = new TimeSeriesItem();
        tempItem.setCreator(ts.getCreator());
        tempItem.setDate(Util.dateFormatter.format(new Date(ts.getDate().getTime())));
        tempItem.setDescription(ts.getDescription());
        tempItem.setId(ts.getId());
        tempItem.setIsVersionOf(ts.getIsVersionOf());
        tempItem.setLenght((long)ts.getLegth());
        tempItem.setPublished(ts.isPublished());
        tempItem.setPublisher(ts.getPublisher());
        tempItem.setRights(ts.getRights());
        tempItem.setSourceId(ts.getSourceId());
        tempItem.setSourceName(ts.getSourceName());
        tempItem.setTitle(ts.getTitle());
        tempItem.setType(ts.getType());
        return tempItem;
    }
}

