/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.MapItemType;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.graphtools.core.StatisticsGenerator;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.analysis.run.CategoryGuesser;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.TimeSeries;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.ConfigurationConsumer;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.ConfigurationParserHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private String dbUsername;
    private String dbPassword;
    private String dblocation;
    private String dbPackage;
    private String dbdialectforhibernate;
    private StatisticsGenerator statisticsGenerator;
    private CategoryGuesser guesser;
    private LexicalEngineConfiguration possibleValueRetrieverConfiguration;
    private VTIDataExtender vtiDataExtender;
    private HashMap<String, TSMode> modePerScope = new HashMap();
    private HashMap<String, MapItemType[]> propsPerScope = new HashMap();
    private ISNotifier.GCUBENotificationTopic configurationResourceTopic;
    private ISNotifier notifier;

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/contentmanagement/timeseriesservice";
    }

    public TSMode getTsMode() {
        this.logger.trace((Object)("caller scope is " + ServiceContext.getContext().getScope().toString() + " and value is " + (Object)((Object)this.modePerScope.get(ServiceContext.getContext().getScope().toString()))));
        TSMode mode = this.modePerScope.get(ServiceContext.getContext().getScope().toString());
        if (mode == null) {
            return TSMode.TimeSeries;
        }
        return mode;
    }

    public MapItemType[] getProperties() {
        GCUBEScope scope = ServiceContext.getContext().getScope();
        this.logger.trace((Object)("the request for properties is from scope " + scope));
        if (scope.getType() == GCUBEScope.Type.VRE) {
            scope = scope.getEnclosingScope();
        }
        if (!this.propsPerScope.containsKey(scope.toString())) {
            this.logger.trace((Object)("the scope " + scope + " has not been found in the properties"));
            return new MapItemType[0];
        }
        return this.propsPerScope.get(scope.toString());
    }

    public VTIDataExtender getVtiDataExtender() {
        return this.vtiDataExtender;
    }

    public void onInitialisation() {
        try {
            this.notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            this.configurationResourceTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource"));
            this.configurationResourceTopic.setPrecondition("//profile[contains(.,'<SecondaryType>ServicesConfiguration</SecondaryType>') and contains(.,'<Name>TimeSeriesServiceSetup</Name>')]");
            this.configurationResourceTopic.setUseRenotifier(false);
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                if (scope.getType() == GCUBEScope.Type.VRE) continue;
                this.initializeProperties(scope);
                this.notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new ConfigurationConsumer(scope), Collections.singletonList(this.configurationResourceTopic), (GCUBESecurityManager)ServiceContext.getContext(), new GCUBEScope[]{scope});
                if (scope.getType() != GCUBEScope.Type.VO) continue;
                this.setScope(scope);
                try {
                    this.vtiDataExtender = new VTIDataExtender(this.getTSGeotoolsConfiguration());
                }
                catch (Exception e) {
                    this.logger.warn((Object)"erro initializing vtiExtender", (Throwable)e);
                }
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(this.getFile("dbprop.properties", new boolean[]{false})));
            this.dbUsername = prop.getProperty("dbusername", "");
            this.dbPassword = prop.getProperty("dbpassword", "");
            this.dblocation = prop.getProperty("dblocation", "");
            this.dbPackage = prop.getProperty("dbpackage", "org.gcube.dbinterface.postgres");
            this.dbdialectforhibernate = prop.getProperty("dbdialectforhibernate", "org.hibernate.dialect.PostgreSQLDialect");
            this.logger.trace((Object)(String.valueOf(this.dbUsername) + " " + this.dbPassword + " " + this.dblocation + " " + this.dbPackage));
            DBSession.initialize((String)this.dbPackage, (String)this.dbUsername, (String)this.dbPassword, (String)this.dblocation);
            LexicalEngineConfiguration conf = new LexicalEngineConfiguration();
            conf.setDatabaseUserName(this.getDBUserName());
            conf.setDatabasePassword(this.getDBPassword());
            conf.setDatabaseUserName("jdbc:postgresql:" + this.dblocation);
            conf.setDatabaseDriver(DBSession.drivers);
            conf.setDatabaseURL(DBSession.entireUrl);
            conf.setDatabaseDialect(this.getDbdialectforhibernate());
            conf.setDatabaseAutomaticTestTable("connectiontesttable");
            conf.setDatabaseIdleConnectionTestPeriod("3600");
            Map fieldMapping = CodeList.getInfo();
            conf.setReferenceTable(CodeList.getTableName());
            this.logger.debug((Object)("fields are: " + (String)fieldMapping.get("tableName") + " " + (String)fieldMapping.get("id") + " " + (String)fieldMapping.get("name") + " " + (String)fieldMapping.get("description")));
            this.logger.debug((Object)("config dir is " + (String)this.getProperty("configDir", new boolean[]{true})));
            conf.setReferenceColumn((String)fieldMapping.get("tableName"));
            conf.setIdColumn((String)fieldMapping.get("id"));
            conf.setNameHuman((String)fieldMapping.get("name"));
            conf.setDescription((String)fieldMapping.get("description"));
            this.guesser = new CategoryGuesser((String)this.getProperty("configDir", new boolean[]{true}));
            this.guesser.init(conf);
            this.statisticsGenerator = new StatisticsGenerator();
            this.statisticsGenerator.init(String.valueOf((String)this.getProperty("configDir", new boolean[]{true})) + File.separator, conf);
            conf.setEntryAcceptanceThreshold(30.0f);
            conf.setReferenceChunksToTake(-1);
            conf.setTimeSeriesChunksToTake(-1);
            conf.setUseSimpleDistance(false);
            this.possibleValueRetrieverConfiguration = conf;
            this.logger.trace((Object)("extender is null ?" + (this.vtiDataExtender == null)));
            this.triggerCreationForReadOnlyUser();
        }
        catch (Throwable e) {
            this.logger.error((Object)"error initializing service", e);
        }
    }

    public void onShutdown() {
        try {
            if (this.getVtiDataExtender() != null) {
                this.getVtiDataExtender().shutDown();
            }
            this.notifier.unregisterFromISNotification((GCUBESecurityManager)this, Collections.singletonList(this.configurationResourceTopic), ServiceContext.getContext().getInstance().getScopes().values().toArray(new GCUBEScope[0]));
        }
        catch (Exception e) {
            this.logger.error((Object)"error shuttingdown service", (Throwable)e);
        }
    }

    public String getDBUserName() {
        return this.dbUsername;
    }

    public String getDBPassword() {
        return this.dbPassword;
    }

    public String getDbdialectforhibernate() {
        return this.dbdialectforhibernate;
    }

    public CategoryGuesser getGuesser() {
        return this.guesser;
    }

    public LexicalEngineConfiguration getPossibleValueRetrieverConfiguration() {
        return this.possibleValueRetrieverConfiguration;
    }

    public StatisticsGenerator getStatisticsGenerator() {
        return this.statisticsGenerator;
    }

    private void initializeProperties(GCUBEScope scope) {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//SecondaryType", "ServicesConfiguration"), new AtomicCondition("//Name", "TimeSeriesServiceSetup")});
            List resources = client.execute((ISQuery)query, scope);
            if (resources.size() == 0) {
                throw new Exception();
            }
            GCUBEGenericResource resource = (GCUBEGenericResource)resources.get(0);
            this.parseAndSaveConfiguration(resource, scope);
        }
        catch (Exception e) {
            this.logger.warn((Object)("error retrieving the configuration resource for scope " + scope.toString()), (Throwable)e);
        }
    }

    public void parseAndSaveConfiguration(GCUBEGenericResource configurationResource, GCUBEScope scope) throws Exception {
        String resourceBody = configurationResource.getBody();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ConfigurationParserHandler handler = new ConfigurationParserHandler();
        saxParser.parse(new InputSource(new StringReader(resourceBody)), (DefaultHandler)handler);
        for (ConfigurationParserHandler.Pair pair : handler.getPairs()) {
            try {
                this.modePerScope.put(String.valueOf(scope.toString()) + "/" + pair.key, TSMode.valueOf(pair.value));
                this.logger.trace((Object)("found for ts mode: " + scope.toString() + "/" + pair.key + " with value " + pair.value));
            }
            catch (Throwable e) {
                this.logger.warn((Object)"erorr resolving the ts mode", e);
            }
        }
        this.propsPerScope.put(scope.toString(), handler.getMapItems().toArray(new MapItemType[handler.getMapItems().size()]));
    }

    private void triggerCreationForReadOnlyUser() {
        DBSession session = null;
        try {
            session = DBSession.connect();
            session.executeUpdate("CREATE role readonlyuser with login;");
        }
        catch (Exception e) {
            this.logger.warn((Object)"error creating readonlyuser role ", (Throwable)e);
        }
        try {
            String tableName = TimeSeries.getTableName();
            session.executeUpdate("CREATE OR REPLACE FUNCTION grant_permission() RETURNS trigger  AS $$ BEGIN  EXECUTE 'GRANT SELECT ON TABLE ' || 'ts_' || replace(NEW.ifield0, '-', '_') || ' TO readonlyuser' ; RETURN NULL; END; $$ language plpgsql;");
            session.executeUpdate("CREATE TRIGGER permission  AFTER  INSERT ON " + tableName + " FOR EACH ROW EXECUTE PROCEDURE grant_permission();");
        }
        catch (Exception e) {
            this.logger.warn((Object)"error creating trigger", (Throwable)e);
        }
        if (session != null) {
            session.release();
        }
    }

    public TSGeoToolsConfiguration getTSGeotoolsConfiguration() throws Exception {
        TSGeoToolsConfiguration configuration = new TSGeoToolsConfiguration();
        configuration.setConfigPath((String)ServiceContext.getContext().getProperty("configDir", new boolean[]{true}));
        configuration.setTimeSeriesDatabase("jdbc:postgresql:" + this.dblocation);
        configuration.setTimeSeriesUserName(this.dbUsername);
        configuration.setTimeSeriesPassword(this.dbPassword);
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERuntimeResourceQuery query = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Category", "Gis"), new AtomicCondition("/Profile/Name", "TimeSeriesDataStore")});
        List timeSeriesDatastoreResources = client.execute((ISQuery)query, this.getScope());
        if (timeSeriesDatastoreResources.size() == 0) {
            String erroreMessage = "no runtimeResources found for timeseries datastore";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        boolean timeseriesDatastoreAccesspointFound = false;
        if (timeSeriesDatastoreResources.size() > 0) {
            for (AccessPoint accessPoint : ((GCUBERuntimeResource)timeSeriesDatastoreResources.get(0)).getAccessPoints()) {
                if (accessPoint.getEntryname().equals("jdbc")) {
                    configuration.setGeoServerDatabase(accessPoint.getEndpoint());
                    configuration.setGeoServerUserName(accessPoint.getUsername());
                    configuration.setGeoServerPassword(accessPoint.getPassword());
                } else if (accessPoint.getEntryname().equals("jdbcaquamaps")) {
                    configuration.setAquamapsDatabase(accessPoint.getEndpoint());
                    configuration.setAquamapsUserName(accessPoint.getUsername());
                    configuration.setAquamapsPassword(accessPoint.getPassword());
                }
                timeseriesDatastoreAccesspointFound = true;
            }
        }
        if (!timeseriesDatastoreAccesspointFound) {
            String erroreMessage = "no accesspoint found for timeseries datastore entry";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        return configuration;
    }

    public GISInformation getGISInformation() throws Exception {
        GISInformation gisInfo = new GISInformation();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERuntimeResourceQuery query = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
        query.clearConditions();
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Category", "Gis"), new AtomicCondition("/Profile/Name", "GeoNetwork")});
        List geonetworkResources = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
        if (geonetworkResources.size() == 0) {
            String erroreMessage = "no runtimeResources found for Geonetwork";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        boolean geoNetworkAccesspointFound = false;
        for (AccessPoint accessPoint : ((GCUBERuntimeResource)geonetworkResources.get(0)).getAccessPoints()) {
            if (!accessPoint.getEntryname().equals("geonetwork")) continue;
            gisInfo.setGeoNetworkUrl(accessPoint.getEndpoint());
            gisInfo.setGeoNetworkUserName(accessPoint.getUsername());
            gisInfo.setGeoNetworkPwd(accessPoint.getPassword());
            geoNetworkAccesspointFound = true;
            break;
        }
        if (!geoNetworkAccesspointFound) {
            String erroreMessage = "no accesspoint found for geonetwork entry";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        query.clearConditions();
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Category", "Gis"), new AtomicCondition("/Profile/Name", "GeoServer")});
        List geoserverResources = client.execute((ISQuery)query, this.getScope());
        if (geoserverResources.size() == 0) {
            String erroreMessage = "no runtimeResources found for GeoServer";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        boolean geoServerAccesspointFound = false;
        for (AccessPoint accessPoint : ((GCUBERuntimeResource)geoserverResources.get(0)).getAccessPoints()) {
            if (!accessPoint.getEntryname().equals("geoserver")) continue;
            gisInfo.setGisUserName(accessPoint.getUsername());
            gisInfo.setGisPwd(accessPoint.getPassword());
            gisInfo.setGisUrl(accessPoint.getEndpoint());
            gisInfo.setGisDataStore(accessPoint.getProperty("timeseriesDataStore"));
            gisInfo.setGisWorkspace(accessPoint.getProperty("timeseriesWorkspace"));
            geoServerAccesspointFound = true;
            break;
        }
        if (!geoServerAccesspointFound) {
            String erroreMessage = "no accesspoint found for geoserver entry";
            this.logger.error((Object)erroreMessage);
            throw new Exception(erroreMessage);
        }
        return gisInfo;
    }

    public static enum TSMode {
        TimeSeries,
        VTI;

    }
}

