package org.gcube.contentmanagement.timeseriesservice.impl.importer.state;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;
import org.gcube.common.dbinterface.tables.SimpleTable;

public class ImportPersistence extends GCUBEWSFilePersistenceDelegate<ImportResource>{

	@SuppressWarnings("unchecked")
	protected void onLoad(ImportResource resource, ObjectInputStream ois) throws Exception {
		super.onLoad(resource, ois);
		resource.setId((String) ois.readObject());
		resource.setTable((SimpleTable) ois.readObject());
		resource.setTableDefinition((String[]) ois.readObject());
		resource.setFieldLenght((Map<String, int[]>) ois.readObject());
	}
	
	protected void onStore(ImportResource resource, ObjectOutputStream oos) throws Exception {
		super.onStore(resource, oos);
		oos.writeObject(resource.getId());
		oos.writeObject(resource.getTable());
		oos.writeObject(resource.getTableDefinition());
		oos.writeObject(resource.getFieldLenght());
	}
}
