package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.util.List;

import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;

public abstract class EditProxy {

	public abstract void replaceValue(int rowId, Object value) throws Exception;
	
	public abstract void modifyEntryId(String fieldId, String newId, long rowId) throws Exception;
	
	public abstract void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception;
	
	public abstract void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception;
	
	public abstract void replaceIds(String fieldId, String oldId, String newId) throws Exception;
	
	public abstract void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception;
	
	public abstract void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception;
	
	public abstract void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception;
	
	public abstract List<ErrorPair> getDistinctErrors() throws Exception;
	
	public abstract String getPossibleValues(String word) throws Exception;
	
	public abstract ColumnDefinition getTemporaryColumnDefinition(ColumnDefinition columnDefinition) throws Exception;
	
	public abstract List<CurationHistoryItem> getHistoryItems() throws Exception;
}
