/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.stubs.calls;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class RSWrapper {
    public static GCUBELog logger = new GCUBELog(RSWrapper.class);
    private RecordWriter<GenericRecord> writer = null;

    public static File getStreamFromLocator(URI locator) throws Exception {
        GenericRecord rec;
        ForwardReader reader = new ForwardReader(locator);
        File importedFile = null;
        reader.setIteratorTimeout(300L);
        Iterator i$ = reader.iterator();
        while (i$.hasNext() && (rec = (GenericRecord)i$.next()) != null) {
            logger.trace((Object)"record is not null");
            rec.getField("fileToImport").makeAvailable();
            BufferedInputStream bin = new BufferedInputStream((InputStream)rec.getField("fileToImport").getMediatingInputStream());
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            importedFile = File.createTempFile("import", ".zip");
            FileOutputStream fos = new FileOutputStream(importedFile);
            while ((bytesRead = bin.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.close();
            reader.close();
        }
        return importedFile;
    }

    public RSWrapper(GCUBEScope scope) throws Exception {
        FileFieldDefinition fileFieldDefinition = new FileFieldDefinition("fileToImport");
        fileFieldDefinition.setDeleteOnDispose(true);
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fileFieldDefinition})};
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), defs);
    }

    public void add(File fileInput) throws Exception {
        GenericRecord gr = new GenericRecord();
        gr.setFields((Field[])new FileField[]{new FileField(fileInput)});
        this.writer.put((Record)gr);
    }

    public void close() throws Exception {
        this.writer.close();
    }

    public URI getLocator() throws GRS2WriterException {
        logger.trace((Object)this.writer.getLocator().toString());
        return this.writer.getLocator();
    }

    static {
        try {
            ArrayList<PortRange> ports = new ArrayList<PortRange>();
            ports.add(new PortRange(3000, 3050));
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), ports, true));
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        }
        catch (Exception e) {
            logger.warn((Object)"error initilaizing the RSWrapper", (Throwable)e);
        }
    }
}

