package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;

public abstract class CodeListCall {

	protected static String getServiceClass() {
		return Constant.SERVICE_CLASS;
	}

	protected static String getServiceName() {
		return Constant.SERVICE_NAME;
	}
	
	protected static EndpointReferenceType getEpr(GCUBEScope scope, String endpoint) throws NoServiceFoundException, Exception{
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERIQuery query = client.getQuery(GCUBERIQuery.class);
		query.addAtomicConditions(new AtomicCondition("//ServiceClass",getServiceClass()), new AtomicCondition("//ServiceName", getServiceName()));
		List<GCUBERunningInstance> ris =client.execute(query, scope);
		if (ris.size()==0) throw new NoServiceFoundException();
		return  ris.get(0).getAccessPoint().getEndpoint(endpoint);
	}
	
	
	
}
