/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.timeseries;

import java.rmi.Remote;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.calls.GCUBECall;
import org.gcube.common.core.utils.calls.RICall;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.calls.TSCall;
import org.gcube.contentmanagement.timeseriesservice.calls.importer.ImporterFactoryCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.OpenMsg;
import org.gcube.contentmanagement.timeseriesservice.stubs.ServiceProperties;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesFactoryPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.TimeSeriesFactoryServiceAddressingLocator;

public class TimeSeriesFactoryCall
extends TSCall {
    GCUBELog logger = new GCUBELog(ImporterFactoryCall.class);

    public TimeSeriesFactoryCall(GCUBEScope scope, GCUBESecurityManager[] securityManager) throws Exception {
        super(scope, securityManager);
    }

    public String getPortTypeName() {
        return "gcube/contentmanagement/timeseriesservice/timeseries/TimeSeriesFactory";
    }

    public CreateTsResponse create(String title, String description, String creator, String publisher, String rights, String type, String relatedCurationId) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        final CreateTsRequest createRequest = new CreateTsRequest(creator, description, publisher, relatedCurationId, rights, title, type);
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.create(createRequest);
            }
        }.run();
        return (CreateTsResponse)result.value;
    }

    public EndpointReferenceType open(final String id, final String user) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.open(new OpenMsg(id, user));
            }
        }.run();
        return (EndpointReferenceType)result.value;
    }

    public TimeSeriesItem[] getPublishedTimeSeries() throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                TimeSeriesItemsArray tsa = (factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()})).getPublishedTimeSeries(new VOID());
                result.value = tsa != null && tsa.getItems() != null ? tsa.getItems() : new TimeSeriesItem[0];
            }
        }.run();
        return (TimeSeriesItem[])result.value;
    }

    public TimeSeriesItem getTimeSeriesInfoById(final String tsId) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.getTimeSeriesInfoById(tsId);
            }
        }.run();
        return (TimeSeriesItem)result.value;
    }

    public void removeTimeSeries(final String id) throws Exception {
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                factoryPT.removeTimeSeries(id);
            }
        }.run();
    }

    public CreateFromTsResponse createFromTs(String title, String description, String creator, String publisher, String rights, String type, String tsSourceId) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        final CreateFromTsRequest createRequest = new CreateFromTsRequest(creator, description, publisher, rights, title, tsSourceId, type);
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.createFromTs(createRequest);
            }
        }.run();
        return (CreateFromTsResponse)result.value;
    }

    public TimeSeriesItem[] getUserRelatedTimeSeries(final String user) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                TimeSeriesItemsArray tsa = (factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()})).getImportedTimeSeries(user);
                result.value = tsa != null && tsa.getItems() != null ? tsa.getItems() : new TimeSeriesItem[0];
            }
        }.run();
        return (TimeSeriesItem[])result.value;
    }

    public ServiceProperties getServiceProperties() throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(){

            public void interact(EndpointReferenceType epr) throws Exception {
                TimeSeriesFactoryPortType factoryPT = new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
                factoryPT = (TimeSeriesFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.getServiceProperties(new VOID());
            }
        }.run();
        return (ServiceProperties)result.value;
    }
}

