package org.gcube.contentmanagement.timeseriesservice.calls.timeseries;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.TSCall;
import org.gcube.contentmanagement.timeseriesservice.calls.importer.ImporterFactoryCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.OpenMsg;
import org.gcube.contentmanagement.timeseriesservice.stubs.ServiceProperties;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesFactoryPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.TimeSeriesFactoryServiceAddressingLocator;

/**
 * 
 * @author lucio
 *
 */
public class TimeSeriesFactoryCall  extends TSCall {
		
	GCUBELog logger= new GCUBELog(ImporterFactoryCall.class);
	
		
	public TimeSeriesFactoryCall(GCUBEScope scope,
			GCUBESecurityManager[] securityManager) throws Exception {
		super(scope, securityManager);
	}

	@Override
	public String getPortTypeName() {
		return Constant.TIMESERIES_FACTORY_PT_NAME;
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.TSFactoryInt#create(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public CreateTsResponse create(String title, String description, String creator, String publisher, String rights, String type, String relatedCurationId) throws Exception{
		final ResultHolder<CreateTsResponse> result = new ResultHolder<CreateTsResponse>();
		final CreateTsRequest createRequest= new CreateTsRequest(creator, description,publisher, relatedCurationId, rights, title, type);

		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.create(createRequest);
			}
		}.run();
		return result.value;		
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.TSFactoryInt#open(java.lang.String)
	 */
	
	public EndpointReferenceType open(final String id, final String user) throws Exception{
		final ResultHolder<EndpointReferenceType> result = new ResultHolder<EndpointReferenceType>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.open(new OpenMsg(id, user));
			}
		}.run();
		return result.value;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.TSFactoryInt#getPublishedTimeSeries()
	 */
	public TimeSeriesItem[] getPublishedTimeSeries() throws Exception{
		final ResultHolder<TimeSeriesItem[]> result = new ResultHolder<TimeSeriesItem[]>();
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				TimeSeriesItemsArray tsa=factoryPT.getPublishedTimeSeries(new VOID());
				if (tsa!=null && tsa.getItems()!=null)
						result.value=tsa.getItems();
					else result.value=new TimeSeriesItem[0];		
			}
		}.run();
		return result.value;
	}
			
	public TimeSeriesItem getTimeSeriesInfoById(final String tsId) throws Exception {
		final ResultHolder<TimeSeriesItem> result = new ResultHolder<TimeSeriesItem>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value= factoryPT.getTimeSeriesInfoById(tsId);
			}
		}.run();
		return result.value;
	}

	public void removeTimeSeries(final String id) throws Exception {
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				factoryPT.removeTimeSeries(id);
			}
		}.run();
	}

	public CreateFromTsResponse createFromTs(String title, String description, String creator, String publisher, String rights, String type, String tsSourceId)
			throws Exception {
		
		final ResultHolder<CreateFromTsResponse> result = new ResultHolder<CreateFromTsResponse>();
		final CreateFromTsRequest createRequest= new CreateFromTsRequest(creator, description,publisher, rights, title,tsSourceId, type);

		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.createFromTs(createRequest);
			}
		}.run();
		return result.value;		
	}

	
	public TimeSeriesItem[] getUserRelatedTimeSeries(final String user) throws Exception {
		final ResultHolder<TimeSeriesItem[]> result = new ResultHolder<TimeSeriesItem[]>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				TimeSeriesItemsArray tsa=factoryPT.getImportedTimeSeries(user);
				if (tsa!=null && tsa.getItems()!=null)
						result.value=tsa.getItems();
					else result.value=new TimeSeriesItem[0];		
			}
		}.run();
		return result.value;
	}

	public ServiceProperties getServiceProperties() throws Exception {
		final ResultHolder<ServiceProperties> result = new ResultHolder<ServiceProperties>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				TimeSeriesFactoryPortType factoryPT= new TimeSeriesFactoryServiceAddressingLocator().getTimeSeriesFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value =factoryPT.getServiceProperties(new VOID());
			}
		}.run();
		return result.value;
	}
}
