/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.vti.connectors;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class FAOAreaExtractor {
    public String geoServerURL;
    ConnectionsManager connectionsManager;
    private static String dropTable = "drop table %1$s";
    private static String createTable = "create table %1$s (gid serial NOT NULL)";
    private static String addPointsColumn = "select AddGeometryColumn('%1$s','the_geom',4326,'POINT',2)";
    private static String insertInto = "insert into %1$s(gid, the_geom) values %2$s;";
    private static String insertionStatement = "(%1$s, ST_SetSRID(ST_MakePoint(%2$s,%3$s),4326))";
    private static String intersectionQuery = "select * from (SELECT  distinct a.gid, b.%1$s, ST_Intersects( ST_SetSRID(a.the_geom,4326), ST_SetSRID(b.%2$s,4326)) as r from %3$s as a, \"%4$s\" as b) g where r = 't'";
    private static String faoTableGeoCol = "the_geom";
    private static String faoTableInfoCol = "f_area";
    private String[] faoTables = new String[]{"fifao_FAO_SUB_UNITPolygon", "fifao_FAO_SUB_AREAPolygon", "fifao_FAO_SUB_DIV", "fifao_FAO_DIV", "fifao_FAO_MAJORPolygon"};

    public FAOAreaExtractor(String geoServerURL, ConnectionsManager connectionsManager) {
        this.geoServerURL = geoServerURL;
        this.connectionsManager = connectionsManager;
    }

    public String createTempTable(Point2D.Double[] points) throws Exception {
        String tempTable = ("points_" + UUID.randomUUID()).replace("-", "_");
        this.connectionsManager.GeoserverUpdate(String.format(createTable, tempTable));
        this.connectionsManager.GeoserverQuery(String.format(addPointsColumn, tempTable));
        int m = points.length;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < m; ++i) {
            buff.append(String.format(insertionStatement, i, points[i].x, points[i].y));
            if (i < m - 1 && i % 100 != 0) {
                buff.append(",");
                continue;
            }
            if (i % 100 != 0) continue;
            this.connectionsManager.GeoserverUpdate(String.format(insertInto, tempTable, buff.toString()));
            buff = null;
            buff = new StringBuffer();
        }
        if (buff.length() > 0) {
            this.connectionsManager.GeoserverUpdate(String.format(insertInto, tempTable, buff.toString()));
        }
        return tempTable;
    }

    public void deleteTable(String table) {
        try {
            this.connectionsManager.GeoserverUpdate(String.format(dropTable, table));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().warn((Object)("deleteTable->Could not delete the table " + e.getMessage()));
        }
    }

    public List<Object> intersects(String tempTable, String faoTable, String faoTablegeoColumn, String faoTableInfoColumn) throws Exception {
        List<Object> intersections = this.connectionsManager.GeoserverQuery(String.format(intersectionQuery, faoTableInfoColumn, faoTablegeoColumn, tempTable, faoTable));
        return intersections;
    }

    private String[] createDefaultInitialization() {
        String[] array$ = new String[this.faoTables.length];
        for (int i = 0; i < this.faoTables.length; ++i) {
            array$[i] = "";
        }
        return array$;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<String>[] getAreas(Point2D.Double[] points) {
        String tempTab = "";
        Tuple[] tupleArray = new Tuple[points.length];
        tupleArray = this.setDefaults(points);
        try {
            AnalysisLogger.getLogger().trace((Object)"FAOAreaExtractor->generating temp table");
            tempTab = this.createTempTable(points);
            for (int j = 0; j < this.faoTables.length; ++j) {
                AnalysisLogger.getLogger().trace((Object)"FAOAreaExtractor->performing intersection ");
                List<Object> results = this.intersects(tempTab, this.faoTables[j], faoTableGeoCol, faoTableInfoCol);
                if (results == null) continue;
                int nInters = results.size();
                AnalysisLogger.getLogger().trace((Object)("FAOAreaExtractor->updating tuples for FAO AREA: " + this.faoTables[j]));
                for (int i = 0; i < nInters; ++i) {
                    Object[] row = (Object[])results.get(i);
                    Integer index = (Integer)row[0];
                    String faoArea = (String)row[1];
                    Tuple tupleToUpdate = tupleArray[index];
                    tupleToUpdate.getElements().set(j, faoArea);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)("FAOAreaExtractor->Error was found " + e.getMessage()));
            tupleArray = this.setDefaults(points);
        }
        finally {
            AnalysisLogger.getLogger().trace((Object)"FAOAreaExtractor->deleting table");
            this.deleteTable(tempTab);
        }
        return tupleArray;
    }

    public Tuple<String>[] setDefaults(Point2D.Double[] points) {
        Tuple[] tupleArray = new Tuple[points.length];
        for (int i = 0; i < points.length; ++i) {
            tupleArray[i] = new Tuple<String>(this.createDefaultInitialization());
        }
        return tupleArray;
    }

    public Tuple<String>[] getAreasOLD(Point2D.Double[] points) {
        Tuple[] tupleArray = new Tuple[points.length];
        String area1 = "-9999";
        String area2 = "-9999";
        String area3 = "-9999";
        String area4 = "-9999";
        String area5 = "-9999";
        for (int i = 0; i < points.length; ++i) {
            tupleArray[i] = new Tuple<String>(area1, area2, area3, area4, area5);
        }
        return tupleArray;
    }

    public static void main1(String[] args) {
        System.out.println("GO!");
        Point2D.Double[] points = new Point2D.Double[]{new Point2D.Double(-20.303, 66.537), new Point2D.Double(-21.71, 63.837)};
        FAOAreaExtractor fae = new FAOAreaExtractor("http://geoserver.d4science-ii.research-infrastructures.eu", null);
        fae.getAreas(points);
    }

    public static void main(String[] args) throws Exception {
        EngineConfiguration configurationTS = new EngineConfiguration();
        configurationTS.setConfigPath("./cfg/");
        configurationTS.setDatabaseURL("jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdatedOLD");
        configurationTS.setDatabaseUserName("utente");
        configurationTS.setDatabasePassword("d4science");
        EngineConfiguration configurationGEO = new EngineConfiguration();
        configurationGEO.setConfigPath("./cfg/");
        configurationGEO.setDatabaseURL("jdbc:postgresql://geoserver-dev.d4science-ii.research-infrastructures.eu/aquamapsdb");
        configurationGEO.setDatabaseUserName("postgres");
        configurationGEO.setDatabasePassword("d4science2");
        ConnectionsManager connectionsManager = new ConnectionsManager(configurationTS.getConfigPath());
        connectionsManager.initTimeSeriesConnection(configurationTS);
        connectionsManager.initGeoserverConnection(configurationGEO);
        String url = "http://geoserver.d4science-ii.research-infrastructures.eu";
        FAOAreaExtractor fao = new FAOAreaExtractor(url, connectionsManager);
        AnalysisLogger.setLogger((String)"./cfg/ALog.properties");
        Point2D.Double[] points = new Point2D.Double[]{new Point2D.Double(-129.023, 16.72)};
        Tuple<String>[] tuple = fao.getAreas(points);
        for (int i = 0; i < tuple.length; ++i) {
            System.out.println(tuple[i]);
        }
    }

    public static void main2(String[] args) {
        System.out.println("GO!");
        String[] types = new String[]{"aquamaps:fifao_FAO_SUB_UNIT", "aquamaps:fifao_FAO_SUB_DIV", "aquamaps:fifao_FAO_SUB_AREA", "aquamaps:fifao_FAO_DIV", "aquamaps:fifao_FAO_MAJOR"};
    }
}

