/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util;

import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceTargetFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util.ObjectToWSConditionsConverter;

public class ObjectToWSFiltersConverter {
    public static WSFilter[] convertToArrayOfWSFilter(List<SMSFilter> filters) {
        LinkedList<WSFilter> wsFilters = new LinkedList<WSFilter>();
        for (SMSFilter filter : filters) {
            wsFilters.add(ObjectToWSFiltersConverter.convertToWsFilter(filter));
        }
        return wsFilters.toArray(new WSFilter[wsFilters.size()]);
    }

    public static WSFilter convertToWsFilter(SMSFilter filter) {
        WSFilter wsFilter = new WSFilter();
        switch (filter.getType()) {
            case REFERENCE_FILTER: {
                wsFilter.setReferenceFilter(ObjectToWSFiltersConverter.convertToWSReferenceFilter((ReferenceFilter)filter));
                break;
            }
            case PROPERTY_FILTER: {
                wsFilter.setPropertyFilter(ObjectToWSFiltersConverter.convertToWsPropertyFilter((PropertyFilter)filter));
            }
        }
        return wsFilter;
    }

    public static WSReferenceFilter convertToWSReferenceFilter(ReferenceFilter referenceFilter) {
        WSReferenceFilter wsReferenceFilter = new WSReferenceFilter();
        wsReferenceFilter.setPrimaryRole(referenceFilter.getPrimaryRole());
        wsReferenceFilter.setSecondaryRole(referenceFilter.getSecondaryRole());
        switch (referenceFilter.getReferenceFilterType()) {
            case SOURCE_FILTER: {
                wsReferenceFilter.setReferenceSourceFilter(ObjectToWSFiltersConverter.convertToWsReferenceSourceFilter((ReferenceSourceFilter)referenceFilter));
                break;
            }
            case TARGET_FILTER: {
                wsReferenceFilter.setReferenceTargetFilter(ObjectToWSFiltersConverter.convertToWsReferenceTargetFilter((ReferenceTargetFilter)referenceFilter));
            }
        }
        return wsReferenceFilter;
    }

    protected static WSReferenceSourceFilter convertToWsReferenceSourceFilter(ReferenceSourceFilter sourceFilter) {
        return new WSReferenceSourceFilter(sourceFilter.getSourceOid());
    }

    protected static WSReferenceTargetFilter convertToWsReferenceTargetFilter(ReferenceTargetFilter targetFilter) {
        return new WSReferenceTargetFilter(targetFilter.getTargetOid());
    }

    public static WSPropertyFilter convertToWsPropertyFilter(PropertyFilter propertyFilter) {
        WSPropertyFilter wsPropertyFilter = new WSPropertyFilter();
        WSPropertyCondition condition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(propertyFilter.getPropertyCondition());
        wsPropertyFilter.setCondition(condition);
        return wsPropertyFilter;
    }
}

