/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSReferenceTargetFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util.WSToObjectConditionsConverter;

public class WSToObjectFiltersConverter {
    public static List<SMSFilter> convertToFilters(WSFilter[] arrayOfWSFilter) {
        if (arrayOfWSFilter == null || arrayOfWSFilter.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<SMSFilter> filters = new LinkedList<SMSFilter>();
        for (WSFilter wsFilter : arrayOfWSFilter) {
            filters.add(WSToObjectFiltersConverter.convertToFilter(wsFilter));
        }
        return filters;
    }

    public static SMSFilter convertToFilter(WSFilter wsFilter) {
        if (wsFilter.getReferenceFilter() != null) {
            return WSToObjectFiltersConverter.convertToReferenceFilter(wsFilter.getReferenceFilter());
        }
        if (wsFilter.getPropertyFilter() != null) {
            return WSToObjectFiltersConverter.convertToPropertyFilter(wsFilter.getPropertyFilter());
        }
        throw new IllegalArgumentException("Can't convert the WSFilter");
    }

    public static ReferenceFilter convertToReferenceFilter(WSReferenceFilter wsReferenceFilter) {
        String primaryRole = wsReferenceFilter.getPrimaryRole();
        String secondaryRole = wsReferenceFilter.getSecondaryRole();
        if (wsReferenceFilter.getReferenceSourceFilter() != null) {
            return WSToObjectFiltersConverter.convertToReferenceSourceFilter(primaryRole, secondaryRole, wsReferenceFilter.getReferenceSourceFilter());
        }
        if (wsReferenceFilter.getReferenceTargetFilter() != null) {
            return WSToObjectFiltersConverter.convertToReferenceTargetFilter(primaryRole, secondaryRole, wsReferenceFilter.getReferenceTargetFilter());
        }
        throw new IllegalArgumentException("Can't convert the WSReferenceFilter");
    }

    protected static ReferenceSourceFilter convertToReferenceSourceFilter(String primaryRole, String secondaryRole, WSReferenceSourceFilter wsReferenceSourceFilter) {
        return new ReferenceSourceFilter(primaryRole, secondaryRole, wsReferenceSourceFilter.getSourceOid());
    }

    protected static ReferenceTargetFilter convertToReferenceTargetFilter(String primaryRole, String secondaryRole, WSReferenceTargetFilter wsReferenceTargetFilter) {
        return new ReferenceTargetFilter(primaryRole, secondaryRole, wsReferenceTargetFilter.getTargetOid());
    }

    public static PropertyFilter convertToPropertyFilter(WSPropertyFilter wsPropertyFilter) {
        PropertyCondition propertyCondition = WSToObjectConditionsConverter.convertToPropertyCondition(wsPropertyFilter.getCondition());
        return new PropertyFilter(propertyCondition);
    }
}

