/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer.gfal;

import it.infn.catania.gfal.GFalFile;
import it.infn.catania.gfal.GFalFileException;
import it.infn.catania.gfal.GFalUtilities;
import it.infn.catania.gfal.GFalUtilitiesException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.networkFileTransfer.gfal.BufferedGFALInputStream;
import org.gcube.contentmanagement.baselayer.networkFileTransfer.gfal.BufferedGFALOutputStream;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class GFALRawContentManager
implements RawFileContentManager,
InstantiableManager {
    public static final String DILIGENT_FOLDER = "grid/diligent/storagemanagement/";
    public static final int RETURN_CODE_FILE_ACCESSIBLE = 0;
    static final String DATA_PROVIDER_PREFIX = "gfal://";
    final String URL_PREFIX;
    final String STORAGE_ELEMENT;
    private static final Log log = LogFactory.getLog(GFALRawContentManager.class);

    public static String getDataProviderPrefix() {
        return DATA_PROVIDER_PREFIX;
    }

    public GFALRawContentManager(String managedURL, String storageElementToCreateNewFiles) throws ValueNotValidException {
        this.URL_PREFIX = managedURL;
        log.debug((Object)("Managing: " + managedURL));
        this.STORAGE_ELEMENT = storageElementToCreateNewFiles;
    }

    protected String getPrefixedLocation(String locationWithoutPrefix) {
        if (this.URL_PREFIX == null || this.URL_PREFIX.equals("")) {
            return locationWithoutPrefix;
        }
        return this.URL_PREFIX + locationWithoutPrefix;
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        if (BaseLayerUtils.requestsFor("create-new-file-when-file-exists", hints) && !hints.isConsumedHint("create-new-file-when-file-exists")) {
            uniqueStorageID = BaseLayerUtils.makePseudoUniqueLocation(new RawContentLocation(uniqueStorageID, this.getDataProvider()), this, hints).getContentID();
            hints.markHint("create-new-file-when-file-exists", true);
        }
        String gfalLocation = this.getPrefixedLocation(uniqueStorageID);
        RawContentLocation newLocation = new RawContentLocation(uniqueStorageID, this.getDataProvider());
        try {
            GFalFile outputFile = new GFalFile();
            log.debug((Object)("Opening file at '" + gfalLocation + "'."));
            try {
                outputFile.openFile(gfalLocation, 1, 644, true);
            }
            catch (GFalFileException ge1) {
                log.debug((Object)("Caught exception: " + ge1.getMessage() + ", trying now to create file instead."));
                try {
                    outputFile.createFile(gfalLocation, 644, true, true);
                }
                catch (GFalFileException ge2) {
                    log.debug((Object)("Caught exception: " + ge2.getMessage() + " - even this failed. Trying now to create with generated SURL."));
                    outputFile.createFile(this.STORAGE_ELEMENT, 644, false, true);
                }
            }
            BufferedGFALOutputStream os = new BufferedGFALOutputStream(outputFile, hints);
            long transferred = binaryFileContent.writeToStreamRespectingLimit(os);
            hints.addHint("bytes-transferred", transferred + "");
            hints.markHint("bytes-transferred", true);
            os.close();
            if (!BaseLayerUtils.requestsFor("do-not-register", hints)) {
                String lfnName = "lfn:grid/diligent/storagemanagement/" + uniqueStorageID;
                log.debug((Object)("Registering file as '" + lfnName + "'."));
                outputFile.lfcRegisterFile(lfnName);
                hints.addHint("catalog-file-name", lfnName);
            } else {
                hints.addHint("catalog-file-name", outputFile.getSurl());
            }
            return newLocation;
        }
        catch (GFalFileException gfe) {
            log.error((Object)"Could not save raw content.", (Throwable)gfe);
            throw new BaseLayerException("Could not save raw content. Reason: " + gfe.getMessage(), gfe);
        }
        catch (IOException ioe) {
            log.error((Object)"Could not save raw content.", (Throwable)ioe);
            throw new BaseLayerException("Could not save raw content. Reason: " + ioe.getMessage(), ioe);
        }
    }

    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        String gfalLocation = this.getPrefixedLocation(location.getContentID());
        try {
            GFalFile inputFile = new GFalFile();
            inputFile.openFile(gfalLocation, 644, 0, true);
            BufferedGFALInputStream is = new BufferedGFALInputStream(inputFile, hints);
            long size = this.getFileSize(gfalLocation);
            BaseLayerStream bls = new BaseLayerStream(is, size);
            bls.setBuffered(true);
            return bls;
        }
        catch (GFalFileException gfe) {
            log.error((Object)"Could not save raw content.", (Throwable)gfe);
            throw new BaseLayerException("Could not save raw content. Reason: " + gfe.getMessage(), gfe);
        }
        catch (IOException ioe) {
            log.error((Object)"Could not save raw content.", (Throwable)ioe);
            throw new BaseLayerException("Could not save raw content. Reason: " + ioe.getMessage(), ioe);
        }
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        String gfalLocation = this.getPrefixedLocation(location.getContentID());
        if (gfalLocation.startsWith("rfio://")) {
            GFalUtilities util = new GFalUtilities();
            try {
                util.deleteFile(gfalLocation);
            }
            catch (GFalUtilitiesException gue) {
                log.error((Object)("Error accessing file '" + gfalLocation + "'.:" + gue.getMessage()));
                log.debug((Object)gue);
                throw new BaseLayerException("Error accesing file:" + gue.getMessage());
            }
        } else {
            throw new ValueNotValidException("GFAL API implements currently only deletion of TURL.", gfalLocation, "contentmanagement:location");
        }
        return true;
    }

    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        String gfalLocation = this.getPrefixedLocation(location.getContentID());
        if (gfalLocation.startsWith("rfio://")) {
            GFalUtilities util = new GFalUtilities();
            try {
                util.accessFile(gfalLocation, 0);
            }
            catch (GFalUtilitiesException gue) {
                log.error((Object)("Error accessing file '" + gfalLocation + "'.:" + gue.getMessage()));
                log.debug((Object)gue);
                throw new BaseLayerException("Error accesing file:" + gue.getMessage());
            }
        }
        try {
            this.getFileSize(gfalLocation);
            return true;
        }
        catch (BaseLayerException ble) {
            log.warn((Object)("Could not determine size of file '" + gfalLocation + "' to check existence. Assuming, file does not exist."));
            log.debug((Object)ble);
            return false;
        }
    }

    public boolean handles(String dataprovider) {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return dataprovider.startsWith("lfn:") || dataprovider.startsWith("rfio://") || dataprovider.startsWith("srm://") || dataprovider.startsWith("guid:");
        }
        if (!dataprovider.startsWith(GFALRawContentManager.getDataProviderPrefix())) {
            return false;
        }
        if (dataprovider.startsWith(this.getDataProvider())) {
            return true;
        }
        String newProvider = GFALRawContentManager.getDataProviderPrefix() + BaseLayerUtils.removeProtocolUsernamePasswordFromURL(dataprovider);
        return newProvider.startsWith(this.getDataProvider());
    }

    public String getDataProvider() {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return DATA_PROVIDER_PREFIX;
        }
        return this.URL_PREFIX;
    }

    public boolean supportsAppending() {
        return true;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        if (BaseLayerUtils.containsDownloadCredentials(hints)) {
            throw new ValueNotValidException("Hints for username and/or password are not allowed in this context.", "permanent location", "contentmanagement:location");
        }
        return currentLocation;
    }

    protected long getFileSize(String prefixedLocation) throws BaseLayerException {
        GFalUtilities util = new GFalUtilities();
        try {
            return util.statFile(prefixedLocation, true)[4];
        }
        catch (GFalUtilitiesException gue) {
            log.error((Object)("Error stating file '" + prefixedLocation + "'.:" + gue.getMessage()));
            log.debug((Object)gue);
            throw new BaseLayerException("Error while trying to stat file:" + gue.getMessage());
        }
    }

    public static GFALRawContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (params.length > 1) {
            return new GFALRawContentManager(params[0], params[1]);
        }
        if (params.length == 1) {
            return new GFALRawContentManager("", params[0]);
        }
        throw new BaseLayerException("Need to know at least a default storage element.");
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

