/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer.gfal;

import it.infn.catania.gfal.GFalFile;
import it.infn.catania.gfal.GFalFileException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class BufferedGFALOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(BufferedGFALOutputStream.class);
    private GFalFile outputFile;
    private int bufferSize;
    private byte[] buffer;
    private int bufferPos = 0;
    private boolean largeFile = true;

    public BufferedGFALOutputStream(GFalFile outputFile, BasicStorageHints hints) throws ValueNotValidException, IOException {
        this.outputFile = outputFile;
        if (hints.hasHint("is-large-file")) {
            this.largeFile = BaseLayerUtils.requestsFor("is-large-file", hints);
            hints.markHint("is-large-file", true);
        }
        this.bufferSize = hints.hasHint("preferred-buffer-size") ? BaseLayerUtils.convertHintToInteger(hints.consumeHint("preferred-buffer-size", false), "preferred-buffer-size") : BaseLayerStream.getDefaultBufferSize();
        if (BaseLayerUtils.requestsFor("append-content", hints)) {
            this.skipToEnd();
            hints.markHint("append-content", true);
        }
    }

    private void skipToEnd() throws IOException {
        try {
            this.outputFile.lseekFile(0L, 2, this.largeFile);
        }
        catch (GFalFileException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(int b) throws IOException {
        this.prepareWrite();
        if (log.isWarnEnabled() && b == -1) {
            log.warn((Object)"Possible attempt to write an input, that was END_OF_STREAM.");
        }
        this.buffer[this.bufferPos++] = (byte)b;
    }

    public int available() {
        return this.buffer.length - this.bufferPos;
    }

    private void prepareWrite() throws IOException {
        if (this.outputFile == null) {
            throw new IOException("Output file has been closed or is unavailable for other reasons.");
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
            this.bufferPos = 0;
        }
        if (this.available() <= 0) {
            this.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        try {
            this.outputFile.closeFile();
        }
        catch (GFalFileException e) {
            throw new IOException(e.getMessage());
        }
        this.outputFile = null;
    }

    public void flush() throws IOException {
        try {
            if (this.bufferPos == 0) {
                return;
            }
            if (this.available() > 0) {
                byte[] filledPartOfBuffer = new byte[this.bufferPos];
                System.arraycopy(this.buffer, 0, filledPartOfBuffer, 0, this.bufferPos);
                this.outputFile.writeFile(filledPartOfBuffer);
            } else {
                this.outputFile.writeFile(this.buffer);
            }
            this.bufferPos = 0;
        }
        catch (GFalFileException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        while (len > 0) {
            this.prepareWrite();
            int copiedToBuffer = Math.min(len, this.available());
            System.arraycopy(b, off, this.buffer, this.bufferPos, copiedToBuffer);
            off += copiedToBuffer;
            this.bufferPos += copiedToBuffer;
            len -= copiedToBuffer;
        }
        assert (len >= 0) : "Read to many bytes";
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }
}

