/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer;

import org.gcube.contentmanagement.baselayer.exceptions.ObjectNotFoundException;
import org.gcube.contentmanagement.baselayer.exceptions.TemporaryUnavailableException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;

public class StorageLayerException
extends Exception {
    private static final long serialVersionUID = 9069382856128367587L;
    private final String subsystem;
    private boolean retryThisInstance = false;
    private boolean retryEquivalentInstance = false;
    private String invalidValue = null;
    private String invalidValueName = null;
    private boolean missingObject = false;

    public StorageLayerException(String message, Throwable cause, String subsystem) {
        super(message, cause);
        this.subsystem = subsystem;
        while (cause != null) {
            if (cause instanceof TemporaryUnavailableException) {
                this.retryThisInstance = true;
            }
            if (cause instanceof OutOfMemoryError) {
                this.retryEquivalentInstance = true;
            }
            if (cause instanceof ObjectNotFoundException) {
                this.missingObject = true;
            }
            if (cause instanceof ValueNotValidException) {
                ValueNotValidException vnve = (ValueNotValidException)cause;
                this.invalidValue = vnve.getInvalidValue();
                this.invalidValueName = vnve.getInvalidValueName();
            }
            cause = cause.getCause();
        }
    }

    public String getSubSystem() {
        return this.subsystem;
    }

    public boolean isInvalidValue() {
        return this.invalidValue != null || this.invalidValueName != null;
    }

    public boolean isMissingObject() {
        return this.missingObject;
    }

    public boolean resolvableBySameInstance() {
        return this.retryThisInstance;
    }

    public boolean resolvableByEquivalentInstance() {
        return this.retryEquivalentInstance;
    }

    public String getInvalidValue() {
        return this.invalidValue;
    }

    public String getInvalidValueName() {
        return this.invalidValueName;
    }

    public boolean objectNotFound() {
        return this.missingObject;
    }
}

