/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class BaseLayerAuthenticator
extends Authenticator {
    final PasswordAuthentication AUTH;
    private static final BaseLayerAuthenticator ANONYMOUS = new BaseLayerAuthenticator("anonymous", "nobody@nobody.com");

    public BaseLayerAuthenticator(String username, String password) {
        this.AUTH = new PasswordAuthentication(username, password.toCharArray());
    }

    public static Authenticator getAnonymousAuthenticator() {
        return ANONYMOUS;
    }

    public static Authenticator getAuthenticatorFor(BasicStorageHints hints) throws ValueNotValidException {
        String user = null;
        String pass = null;
        if (hints.hasHint("user")) {
            user = hints.getHintValue("user");
            hints.markHint("user", true);
        }
        if (hints.hasHint("passwd")) {
            pass = hints.getHintValue("passwd");
            hints.markHint("passwd", true);
        }
        if (user == null && pass == null) {
            return BaseLayerAuthenticator.getAnonymousAuthenticator();
        }
        return new BaseLayerAuthenticator(user, pass);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return this.AUTH;
    }
}

