package org.gcube.contentmanagement.storage.data.transfer.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.util.StringTokenizer;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

public class Utils {
	
	public static IClient getProductionStorageClient() {
		IClient prodClient=null;
		ScopeProvider.instance.set("/d4science.research-infrastructures.eu");
		try {
			prodClient=new StorageClient("org.gcube.portlets.user","home-library","home-library",AccessType.SHARED).getClient();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return prodClient;
	}
	
	public static IClient getDevStorageClient() {
		IClient prodClient=null;
		ScopeProvider.instance.set("/gcube");
		try {
			prodClient=new StorageClient("org.gcube.portlets.user","home-library","home-library",AccessType.SHARED).getClient();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return prodClient;
	}

	
	public static IClient getBackupStorageClient(String serverIp, String scope) {
		ScopeProvider.instance.set(scope);
		IClient backupClient=null;
		try {
			backupClient=new StorageClient("org.gcube.portlets.user","home-library","home-library",AccessType.SHARED, MemoryType.PERSISTENT, serverIp).getClient();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return backupClient;
	}
	
	
	/**
	 * load csv file and transfer all file defined in csv file from backup server to gCube production cluster
	 * @param strFile csv file path
	 * @param serverIp backup server ip
	 */
	public static void csvParseAndTransfer(String strFile, String serverIp){
		 try
         {
                 //create BufferedReader to read csv file
                 BufferedReader br = new BufferedReader( new FileReader(strFile));
                 String strLine = "";
                 StringTokenizer st = null;
                 int lineNumber = 0, tokenNumber = 0;
                 //read comma separated file line by line
                 while( (strLine = br.readLine()) != null)
                 {
                         lineNumber++;
                         //break comma separated line using ","
                         st = new StringTokenizer(strLine, "###");
                         while(st.hasMoreTokens())
                         {
                                 //display csv values
                                 tokenNumber++;
                                 if(tokenNumber == 2){
                                	 String remotePath=st.nextToken();
                                	 
                                	 System.out.println("remotePath: "+remotePath);
                                	 if((remotePath != null) && (remotePath.length()>0)){
                                     	//swap storage 
                                		 try{
		                                    	 IClient backClient=Utils.getBackupStorageClient(serverIp, "/d4science.research-infrastructures.eu");
		                                    	 InputStream is=backClient.get().RFileAsInputStream(remotePath);
		                                    	 if(is != null){
		                                        	 IClient prodClient=Utils.getProductionStorageClient();
		                                     		 prodClient.put(true).LFile(is).RFile(remotePath);
		                                     		 is.close();
		                                     		System.out.println("file transferred: "+remotePath);
		                                    	 }else{
		                                    		 System.out.println(" file not transferred: "+remotePath);
		                                    	 }
                                		 }catch(Exception e){
                                			 System.out.println("Error occurs while parsing file : "+remotePath);
                                		 }

                                	 }
                             		 
                                 }else st.nextToken();
                         }
                         //reset token number
                         tokenNumber = 0;
                 }
                 System.out.println("# lines: "+lineNumber);
         }
         catch(Exception e)
         {
                 System.out.println("Exception while reading csv file "+strFile+": " + e);                  
         }
	}
	
	public static void transferFromCol1ToCol2(String strFile, String serverIp){
		 try
         {
                 //create BufferedReader to read csv file
                 BufferedReader br = new BufferedReader( new FileReader(strFile));
                 String strLine = "";
                 StringTokenizer st = null;
                 int lineNumber = 0, tokenNumber = 0;
                 //read comma separated file line by line
                while( (strLine = br.readLine()) != null)
                 {
                         lineNumber++;
                         //break comma separated line using ","
                         st = new StringTokenizer(strLine, "###");
                         String remotePathBackup=null;
                         while(st.hasMoreTokens())
                         {
                                 //display csv values
                                 tokenNumber++;
                                 if(tokenNumber == 1){
                                	 remotePathBackup=st.nextToken();
                                 }else if(tokenNumber == 2){
                                	 String remotePath=st.nextToken();
                                	 System.out.println("remotePath: "+remotePath);
                                	 if((remotePath != null) && (remotePath.length()>0) && (remotePathBackup != null) && (remotePathBackup.length()>0)){
                                     	//swap storage 
                                		 try{
                                			 System.out.println("Sostitution:");
                                			 System.out.println("remotePath: "+remotePath);
                                			 System.out.println("backup: "+remotePathBackup);
                                			 
		                                    	 IClient backClient=Utils.getBackupStorageClient(serverIp, "/d4science.research-infrastructures.eu");
		                                    	 InputStream is=backClient.get().RFileAsInputStream(remotePathBackup);
		                                    	 if(is != null){
		                                        	 IClient prodClient=Utils.getProductionStorageClient();
		                                     		 prodClient.put(true).LFile(is).RFile(remotePath);
		                                     		 is.close();
		                                     		System.out.println("file transferred: "+remotePathBackup);
		                                    	 }else{
		                                    		 System.out.println(" file not transferred: "+remotePathBackup);
		                                    	 }
                                		 }catch(Exception e){
                                			 System.out.println("Error occurs while parsing file : "+remotePath);
                                		 }

                                	 }
                             		 
                                 }else st.nextToken();
                         }
                         //reset token number
                         tokenNumber = 0;
                 }
                 System.out.println("# lines: "+lineNumber);
         }
         catch(Exception e)
         {
                 System.out.println("Exception while reading csv file "+strFile+": " + e);                  
         }

	}
	
}
