/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkConsumer;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkProducer
implements Runnable {
    MyFile resource;
    long dimensionChunk;
    int totChunks;
    int nThreads;
    ChunkConsumer task;
    Monitor monitor;
    String bucketName;
    final Logger logger = LoggerFactory.getLogger(ChunkProducer.class);

    public ChunkProducer(Monitor monitor, MyFile resource, long dimensionChunk, int totChunks, int nThreads, String bucket, ChunkConsumer consumer) throws FileNotFoundException {
        this.resource = resource;
        this.dimensionChunk = dimensionChunk;
        this.totChunks = totChunks;
        this.nThreads = nThreads;
        this.monitor = monitor;
        this.task = consumer;
        this.bucketName = bucket;
    }

    @Override
    public synchronized void run() {
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.nThreads);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.resource.getPathClient()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.totChunks; ++i) {
            byte[] chunk = null;
            if (!"mongo".equalsIgnoreCase("mongo")) {
                try {
                    chunk = IOUtils.toByteArray(in);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Chunk produced " + i + " with size: " + chunk.length);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("put(MyFile, boolean, boolean) - Produced chunk: " + i);
            }
            String key = this.getBucketName() + i;
            this.resource.setKey(key);
            MyFile copy = this.resource.copyProperties();
            copy.setContent(chunk);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("request in queue: " + key);
            }
            this.monitor.putRequest(copy);
            executor.submit(this.task);
        }
        System.gc();
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" Time for file uploading: " + (System.currentTimeMillis() - start));
            this.logger.debug("Used " + this.nThreads + " threads" + "\n\n");
        }
    }

    public byte[] encodeFile2ByteChunk2(InputStream in, String path, boolean isChunk, long chunkDimension) {
        byte[] encode = null;
        try {
            encode = IOUtils.toByteArray(in);
        }
        catch (IOException e) {
            // empty catch block
        }
        return encode;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }
}

