/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    protected MyFile file;
    protected ServiceEngine engine;

    protected ServiceEngine getEngine() {
        return this.engine;
    }

    protected void setEngine(ServiceEngine engine) {
        this.engine = engine;
    }

    protected MyFile getMyFile() {
        return this.file;
    }

    protected void setMyFile(MyFile f) {
        this.file = f;
    }

    public Resource(MyFile file, ServiceEngine engine) {
        this.setMyFile(file);
        this.setEngine(engine);
    }

    protected MyFile setGenericProperties(String context, String owner, String path, String type) {
        if (type.equalsIgnoreCase("remote")) {
            path = new BucketCoding().mergingPathAndFile(context, path);
        }
        String[] dirs = path.split("/");
        String name = dirs[dirs.length - 1];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("path(String) - name: " + name);
        }
        if (this.file == null) {
            this.file = new MyFile(name);
        } else {
            this.file.setName(name);
        }
        this.file.setOwner(owner);
        String dir = path.substring(0, path.length() - name.length());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("path(String) - path: " + dir);
        }
        if (type.equalsIgnoreCase("local")) {
            if (this.file.getLocalDir() == null) {
                this.file.setLocalDir(dir);
            }
        } else if (this.file.getRemoteDir() == null) {
            this.file.setRemoteDir(dir);
        }
        return this.file;
    }
}

