/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
    private String[] server;
    private String env;
    private String clientId;
    private String backendType;
    protected String username;
    protected String password;
    private static HashMap<String, Object> isCache;

    public String[] getServerAccess(List<ServiceEndpoint> resources) {
        logger.trace("get server from IS");
        if (isCache != null) {
            this.server = (String[])isCache.get("MongoDBServer");
            this.username = (String)isCache.get("username");
            this.password = (String)isCache.get("password");
        }
        if (this.server == null) {
            this.getServerRRFws(resources);
            if (this.server != null) {
                if (isCache == null) {
                    isCache = new HashMap();
                }
                isCache.put("MongoDBServer", this.server);
                if (this.username != null && this.username.length() > 0) {
                    isCache.put("username", this.username);
                    isCache.put("password", this.password);
                }
                logger.info("ISCACHE: ELEMENT INSERTED ");
            }
        } else {
            logger.info("ISCACHE: ELEMENT EXTRACTED");
        }
        return this.server;
    }

    public String getEnvironment(String secondaryType, String field) {
        return this.env;
    }

    public String getClientId(String secondaryType, String field) {
        return this.clientId;
    }

    public String[] getServerRRFws(List<ServiceEndpoint> resources) {
        if (resources.size() > 1) {
            logger.info("found " + resources.size() + " RR ");
            return this.getServers(resources);
        }
        if (resources.size() == 1) {
            logger.info("found only one RR, take it");
            return this.getServers(resources.get(0));
        }
        logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE " + ScopeProvider.instance.get());
        throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: " + ScopeProvider.instance.get());
    }

    public List<ServiceEndpoint> getServiceEndpoint(String category, String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "' and $resource/Profile/Name eq '" + name + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public List<ServiceEndpoint> getStorageEndpoint(String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return resources;
    }

    private String[] getServers(ServiceEndpoint res) {
        ServiceEndpoint.AccessPoint ap2;
        this.server = new String[res.profile().accessPoints().size()];
        int i = 0;
        for (ServiceEndpoint.AccessPoint ap2 : res.profile().accessPoints()) {
            if (!ap2.name().equals("server" + (i + 1))) continue;
            this.server[i] = ap2.address();
            this.username = ap2.username();
            if (this.username != null && this.username.length() > 0) {
                try {
                    this.password = StringEncrypter.getEncrypter().decrypt(ap2.password(), new Key[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator it = res.profile().accessPoints().iterator();
        ap2 = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap2.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get("type");
        this.backendType = type.value();
        logger.info("Type of backend found " + this.backendType);
        return this.server;
    }

    private String[] getServers(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            logger.info("found a RR with priority: ");
            break;
        }
        if (defaultResource != null) {
            this.server = new String[defaultResource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : defaultResource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                this.server[i] = ap.address();
                this.username = ap.username();
                this.password = "";
                if (this.username != null && this.username.length() > 0) {
                    try {
                        this.password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.backendType = this.retrievePropertyValue(defaultResource, "type");
            logger.info("Type of backend found in RR is " + this.backendType);
            return this.server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    public String getBackendType(List<ServiceEndpoint> resources) {
        if (this.backendType != null) {
            return this.backendType;
        }
        this.backendType = this.retrievePropertyValue(resources.get(0), "type");
        return this.backendType;
    }

    public String retrievePropertyValue(String name, String scope) {
        ServiceEndpoint.AccessPoint ap;
        Map map;
        ServiceEndpoint.Property type;
        List<ServiceEndpoint> resources = this.getStorageEndpoint(scope);
        ServiceEndpoint res = resources.get(0);
        Iterator it = res.profile().accessPoints().iterator();
        String value = null;
        while (it.hasNext() && ((type = (ServiceEndpoint.Property)(map = (ap = (ServiceEndpoint.AccessPoint)it.next()).propertyMap()).get(name)) == null || (value = type.value()) == null)) {
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public String getResolverHost(ServiceEndpoint serviceEndpoint) {
        return serviceEndpoint.profile().runtime().hostedOn();
    }
}

