/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionOld;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringDecrypter;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionById
extends SMPConnection {
    private Logger logger = LoggerFactory.getLogger(SMPURLConnectionOld.class);
    private String serviceClass = "Storage-manager";
    private String serviceName = "resolver-uri";
    private String owner = "storage-manager";

    public SMPURLConnectionById(URL url) {
        super(url);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.storageClient(this.url.toString());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    protected InputStream storageClient(String url) throws Exception {
        this.logger.info("url :" + url);
        String[] urlParam = url.split("/");
        String infrastructure = Utils.extractInfrastructureNewVersion(urlParam[2]);
        String rootScope = "/" + infrastructure;
        this.logger.debug("infrastructure: " + rootScope);
        String encrypted = this.retrieveStringEncrypted(urlParam);
        this.logger.debug("String encrypted " + encrypted);
        String phrase = this.retrieveEncryptionPhrase(rootScope);
        String location = new StringDecrypter("DES", phrase).decrypt(encrypted);
        this.logger.info("String decrypted: " + location);
        IClient client = null;
        String currentScope = ScopeProvider.instance.get();
        this.logger.info("current scope found(ScopeProvider): " + currentScope + ". Setting scope before  call StorageClient object: " + rootScope);
        ScopeProvider.instance.set(rootScope);
        client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED).getClient();
        InputStream is = null;
        is = client.get().RFileAsInputStream(location);
        ScopeProvider.instance.set(currentScope);
        return is;
    }

    private String retrieveStringEncrypted(String[] urlParam) {
        String encrypted = urlParam[3];
        for (int i = 4; i < urlParam.length; ++i) {
            encrypted = encrypted + "/" + urlParam[i];
        }
        return encrypted;
    }

    private String retrieveEncryptionPhrase(String rootScope) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String scope = rootScope;
        ScopeProvider.instance.set(scope);
        this.logger.debug("set scope: " + scope);
        String encryptedKey = null;
        ISClientConnector isclient = new ISClientConnector();
        encryptedKey = isclient.retrievePropertyValue("PassPhrase", scope);
        String decryptString = StringEncrypter.getEncrypter().decrypt(encryptedKey, new Key[0]);
        ScopeProvider.instance.set(currentScope);
        return decryptString;
    }
}

