package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.net.URL;

import org.bson.types.ObjectId;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.scope.impl.ScopeBean.Type;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUrl;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Factory class used to determine the right smp url protocol: old format(<2.2.0 version), new format (>= 2.2.0-SNAPSHOT)
 * @author roberto.cirillo
 *
 */
public class SMPURLConnectionFactory {

	static Logger logger=LoggerFactory.getLogger(SMPURLConnectionFactory.class);
	
	public static SMPConnection getSmp(URL url) {
		String urlString=url.toString();
		if(isNewNewType(urlString)){
			logger.info("detected new smp format "+url);
			return new SMPURLConnectionById(url);
		}else{ /* if(isOldType(urlString)){ */
			logger.info("detected old smp format "+url);
			return new SMPURLConnectionOld(url);
		}
//		}else {
//			throw new RuntimeException("smp : incompatible type uri:  "+url);
//		}
	}

	private static boolean isNewType(String urlString) {
		String remoteIdentifier= retrieveRemoteIdentifier(urlString);
		return ObjectId.isValid(remoteIdentifier);
	}
	
	private static boolean isNewNewType(String urlString) {
		String [] urlParam=urlString.split(GetUrl.URL_SEPARATOR);
		String infraHost=urlParam[2];
		String infra=Utils.getInfraFromResolverHost(infraHost);
		String rootScope="/"+infra;
		ScopeBean scope=new ScopeBean(rootScope);
		if(scope.is(Type.INFRASTRUCTURE)){
			return Utils.validationScope2(rootScope);
		}else{
			return false;
		}
	}

	private static boolean isOldType(String urlString) {
		// TO-DO
		return false;
	}
	
	private static String  retrieveRemoteIdentifier(String urlString) {
		String [] urlParam=urlString.split("\\?");
		return extractLocation(urlParam[0]);
	}
	
	private static String extractLocation(String url) {
		String location=null;
		String [] loc=url.split("//");
		String [] params=loc[1].split(GetUrl.URL_SEPARATOR);
		location=params[1];
		return location;
	}
	
	private static String extractInfrastructure(String url) {
		String rootScope=null;
		String [] loc=url.split("//");
		rootScope=loc[1];
		return rootScope;
	}
}
