package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;


import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.operation.GetUrl;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is invoked by the platform with a URL of the smp protocol with new format (>= 2.2.0 version) .
* @author Roberto Cirillo (ISTI-CNR)
 *
 * Example: smp://gcube:mongoId?uhdnfounhcfnshfnrhbvyaeegytf6dfawiuawgcyg
 */
public class SMPURLConnectionById extends SMPConnection {

	private Logger logger= LoggerFactory.getLogger(SMPURLConnectionOld.class);
	private String serviceClass="Storage-manager";
	private String serviceName="resolver-uri";
	private String owner="storage-manager";
	
	/**
	 * Constructs a new instance for a given <code>sm</code> URL.
	 * @param url the URL.
	 */
	public SMPURLConnectionById(URL url) {
		super(url);
	}
	
	/**{@inheritDoc}*/
	@Override 
	public synchronized InputStream getInputStream() throws IOException {
		if (!connected) 
			this.connect(); 
		try {
			StringWriter w = new StringWriter();
		    return storageClient(this.url.toString());			
		}
		catch(Exception e) {
			IOException ioe = new IOException();
			ioe.initCause(e);
			throw ioe;
		}			
	}
	
	
// without scope test
		protected InputStream storageClient(String url) throws Exception {
			logger.info("url :" + url);
			String [] urlParam=url.split(GetUrl.URL_SEPARATOR);
			String infrastructure=Utils.extractInfrastructureNewVersion(urlParam[2]);///extractInfrastructure(urlParam[0]);
			String rootScope="/"+infrastructure;
			logger.debug("infrastructure: "+rootScope);
			String encrypted=retrieveStringEncrypted(urlParam);
			logger.debug("String encrypted "+encrypted);
			String phrase=retrieveEncryptionPhrase(rootScope);
			String location=new StringDecrypter("DES", phrase).decrypt(encrypted);
			logger.info("String decrypted: "+location);
			IClient client=null;
			String currentScope=ScopeProvider.instance.get();
			logger.info("current scope found(ScopeProvider): "+currentScope+". Setting scope before  call StorageClient object: "+ rootScope);
			ScopeProvider.instance.set(rootScope);
				client=new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED).getClient();
			InputStream is=null;
			is=client.get().RFileAsInputStream(location);
			ScopeProvider.instance.set(currentScope);
			return is;
		}
		

		private String  retrieveStringEncrypted(String[] urlParam) {
			String encrypted=urlParam[3];
			int i=4;
			while(i < urlParam.length){
				encrypted=encrypted+GetUrl.URL_SEPARATOR+urlParam[i];
				i++;
			}
			return encrypted;
		}

	
	
	private String retrieveEncryptionPhrase(String rootScope) throws Exception {
		String currentScope=ScopeProvider.instance.get();
		String scope=rootScope;
		ScopeProvider.instance.set(scope);
		logger.debug("set scope: "+scope);
		String encryptedKey=null;
		ISClientConnector isclient=new ISClientConnector();
		encryptedKey=isclient.retrievePropertyValue("PassPhrase", scope);
		String decryptString=org.gcube.common.encryption.StringEncrypter.getEncrypter().decrypt(encryptedKey);
		ScopeProvider.instance.set(currentScope);
		return decryptString;
	}


//	private String extractRootScope(String url) {
//		String rootScope=null;
//		String [] loc=url.split("//");
//		logger.debug("infrastructure extracted: "+loc[1]);
//		String [] params=loc[1].split("#");
//		rootScope=params[0];
//		logger.info("infrastructure: "+rootScope);
//		return rootScope;
//	}

	private String extractLocation(String url) {
		String location=null;
		String [] loc=url.split("//");
		logger.debug("location extracted: "+loc[1]);
		String [] params=loc[1].split("#");
		location=params[1];
		logger.info("MongoID "+location);
		return location;
	}

	
	private String extractInfrastructure(String url) {
		String rootScope=null;
		String [] loc=url.split("//");
		rootScope=loc[1];
		logger.debug("infrastructure extracted: "+rootScope);
		return rootScope;
	}

	private String extractLocationNew(String url) {
		String location=null;
		String [] loc=url.split("//");
		logger.debug("location extracted: "+loc[1]);
		String [] params=loc[1].split("#");
		location=params[1];
		logger.info("MongoID "+location);
		return location;
	}

	
	
	private void createFileTest(InputStream is){
		// write the inputStream to a FileOutputStream
		OutputStream out = null;
		try {
			out = new FileOutputStream(new File("/home/rcirillo/FilePerTest/uriSMPTest.jpg"));
			int read = 0;
			byte[] bytes = new byte[1024];
 			while ((read = is.read(bytes)) != -1) {
				out.write(bytes, 0, read);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	 
		try {
			is.close();
			out.flush();
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		logger.info("New file created!");
	}

}
