package org.gcube.contentmanager.storageclient.wrapper;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient {

	private String clientID;
// public | private | shared. If shared the rwx permits are extended to all services of the same type
	private String typeAccess;
	private String memoryType;
	private String serviceClass;
	private String serviceName;
	private String owner;
	private String server;
	private String scopeString;
	private String currentScope;
	
	private static final Logger logger = LoggerFactory.getLogger(StorageClient.class);
	private static final String DEFAULT_SERVICE_CLASS="ExternalApplication";
	private static final String DEFAULT_SERVICE_NAME="Default";
	
	
	
	/**
	 * Constructor without optional argument created for gcube infrastructure internal use
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	@Deprecated
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope){
		this.currentScope=ScopeProvider.instance.get();
		ScopeProvider.instance.set(scope);
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		setClientId(serviceClass, serviceName, id);
		
	}
	
	/**
	 * Constructor without optional argument created for gcube infrastructure internal use
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType){
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		setClientId(serviceClass, serviceName, id);
		
	}

	/**
	 * Constructor created for external use
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	public StorageClient(String owner, AccessType accessType, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.memoryType= memory.toString();
		this.serviceClass=DEFAULT_SERVICE_CLASS;
		this.serviceName=DEFAULT_SERVICE_NAME;
		setClientId(serviceClass, serviceName, id);
	}
	
	

	/**
	 *  Constructor with optional argument server 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 * @param server: define the mongoDBserver
	 */
	@Deprecated
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server){
		this.currentScope=ScopeProvider.instance.get();
		ScopeProvider.instance.set(scope);
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		setClientId(serviceClass, serviceName, id);
	}

	
	/**
	 *  Constructor with optional argument server 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 * @param server: define the mongoDBserver
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, String server, AccessType accessType){
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		setClientId(serviceClass, serviceName, id);
	}
	
	/**
	 * Constructor with optional argument memoryType
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	@Deprecated
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, MemoryType memory){
		this.currentScope=ScopeProvider.instance.get();
		ScopeProvider.instance.set(scope);
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.memoryType= memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		setClientId(serviceClass, serviceName, id);
	}


	
	/**
	 * Constructor with optional argument memoryType
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.memoryType= memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		setClientId(serviceClass, serviceName, id);
	}

	
	/**
	 * Constructor with optional arguments server and memory 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param server: define the mongoDBserver
	 * @param scope
	 */
	@Deprecated
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server, MemoryType memory){
		this.currentScope=ScopeProvider.instance.get();
		ScopeProvider.instance.set(scope);
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.memoryType=memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		setClientId(serviceClass, serviceName, id);
	}
	
	
	
	/**
	 * Constructor with optional arguments server and memory 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param server: define the mongoDBserver
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory, String server){
		String id=owner;
		this.owner=owner;
		this.scopeString=ScopeProvider.instance.get();
		this.typeAccess=accessType.toString();
		this.memoryType=memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		setClientId(serviceClass, serviceName, id);
	}
	
	/**
	 * Get Instance remote client - storage-manager-core
	 * @return
	 * @throws IllegalStateException if the resource is not founded on the IS 
	 */
	public IClient getClient(){
		String[]  newServer=null;
		if(server==null){
			logger.debug("server not set. Try to query IS in scope: "+scopeString);
			String[] serverFounded=checkVarEnvMongo();
			if(serverFounded==null){
				ISClientConnector isclient=new ISClientConnector();
				serverFounded=isclient.getServer("RuntimeResource");
			}
			newServer=serverFounded;
		}else{
			logger.debug("server founded: "+server);
			String[] serverPassed={server};
			newServer=serverPassed;
		}
		if(newServer==null){
			throw new IllegalStateException("Resource not found on Information System");
		}else{
			String environment=scopeString.substring(scopeString.lastIndexOf("/"));
			if((memoryType != null) && (memoryType.toString().equalsIgnoreCase("VOLATILE"))){
				environment="VOLATILE"+scopeString;
			}
			environment=environment+clientID;
			ServiceEngine engine= new ServiceEngine(newServer, environment, typeAccess, owner);
			engine.setServiceClass(serviceClass);
			engine.setServiceName(serviceName);
			engine.setGcubeAccessType(typeAccess.toLowerCase());
			if(memoryType!=null)
				engine.setGcubeMemoryType(memoryType.toLowerCase());
			engine.setGcubeScope(ScopeProvider.instance.get());
			engine.setOwnerGcube(owner);
			if(currentScope!=null)
				ScopeProvider.instance.set(currentScope);
			return engine;
		}
	}	
	
	@Deprecated
	public IClient getClientV1() throws Exception{
		String[]  newServer=null;
		if(server==null){
			String[] serverFounded=checkVarEnvMongo();
			if(serverFounded==null){
				ISClientConnector isclient=new ISClientConnector();
				serverFounded=isclient.getServer("StorageManager");
			}
			newServer=serverFounded;
		}else{
			String[] serverPassed={server};
			newServer=serverPassed;
		}
		if(newServer==null){
			throw new Exception("Generic resource not found");
		}else{
			String environment=scopeString;
			if((memoryType != null) && (memoryType.toString().equalsIgnoreCase("VOLATILE"))){
				environment="VOLATILE"+scopeString;
			}
			environment=patchV1(environment);
			ServiceEngine engine= new ServiceEngine(newServer, "", environment, typeAccess, owner);
			engine.setServiceClass(serviceClass);
			engine.setServiceName(serviceName);
			engine.setGcubeAccessType(typeAccess.toLowerCase());
			if(memoryType!=null)
				engine.setGcubeMemoryType(memoryType.toLowerCase());
			engine.setGcubeScope(ScopeProvider.instance.get());
			engine.setOwnerGcube(owner);
			if(currentScope!=null)
				ScopeProvider.instance.set(currentScope);
			return engine;
		}
	}	


	private void setClientId(String serviceClass, String serviceName, String id) {
		if(typeAccess.equalsIgnoreCase("public")){
			clientID="";
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=ServiceEngine.FILE_SEPARATOR+"home"+ServiceEngine.FILE_SEPARATOR+serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=ServiceEngine.FILE_SEPARATOR+"home"+ServiceEngine.FILE_SEPARATOR+serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
	}

	@Deprecated
	private String patchV1(String env){
		String newEnvironment=env;
		if(typeAccess.equalsIgnoreCase("public")){
			newEnvironment=env+ServiceEngine.FILE_SEPARATOR+"home"+ServiceEngine.FILE_SEPARATOR+"null"+ServiceEngine.FILE_SEPARATOR;
		}
		return newEnvironment;
	}
	
	/**
	 * Check environmental variable called : "STORAGE_MANAGER_MONGO_SERVER" for retrieving server list
	 * @return
	 */
	private String[] checkVarEnvMongo(){
		Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        
        Iterator<String> iter = keys.iterator();
        String server=null;
        while(iter.hasNext())
        {
            String key = iter.next();
            if(key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")){
            	server=env.get(key);
            }
        }
        if(server!=null){
        	 String [] servers={server};
        	 return servers;
        }
        return null;
	}
	
}