/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringEncrypter;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

public class SMPURLConnection
extends URLConnection {
    Logger logger = Logger.getAnonymousLogger();

    public SMPURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        try {
            this.connected = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            StringWriter w = new StringWriter();
            return this.storageClient(this.url.toString());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private InputStream storageClient(String url) throws Exception {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("url :" + url);
        }
        String[] urlParam = url.split("\\?");
        this.logger.info("String encrypted " + urlParam[1]);
        String param = new StringEncrypter("DES").decrypt(urlParam[1]);
        this.logger.info("String decrypted: " + param);
        String[] getParam = param.split("\\&");
        String serviceClass = null;
        String serviceName = null;
        String owner = null;
        String accessType = null;
        String memoryType = null;
        String scopeType = null;
        AccessType type = null;
        MemoryType mType = null;
        String server = null;
        for (String par : getParam) {
            String[] par1;
            if (par.contains("ServiceClass")) {
                par1 = par.split("=");
                serviceClass = par1[1];
                continue;
            }
            if (par.contains("ServiceName")) {
                par1 = par.split("=");
                serviceName = par1[1];
                continue;
            }
            if (par.contains("owner")) {
                par1 = par.split("=");
                owner = par1[1];
                continue;
            }
            if (par.contains("scope")) {
                par1 = par.split("=");
                scopeType = par1[1];
                continue;
            }
            if (par.contains("server")) {
                par1 = par.split("=");
                server = par1[1];
                continue;
            }
            if (par.contains("AccessType")) {
                par1 = par.split("=");
                accessType = par1[1];
                if (accessType.equalsIgnoreCase("public")) {
                    type = AccessType.PUBLIC;
                    continue;
                }
                if (!accessType.equalsIgnoreCase("shared")) continue;
                type = AccessType.SHARED;
                continue;
            }
            if (!par.contains("MemoryType")) continue;
            par1 = par.split("=");
            memoryType = par1[1];
            if (memoryType.equalsIgnoreCase("VOLATILE")) {
                mType = MemoryType.VOLATILE;
                continue;
            }
            mType = MemoryType.PERSISTENT;
        }
        if (serviceName == null || serviceClass == null || owner == null || scopeType == null || type == null) {
            throw new MalformedURLException();
        }
        GCUBEScope scope = GCUBEScope.getScope(scopeType);
        String location = this.extractLocation(urlParam[0]);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("IStanzio Storage con parametri " + serviceClass + " " + serviceName + " " + owner + " " + (Object)((Object)type) + " " + scope + " " + (Object)((Object)mType) + " location: " + urlParam[0]);
        }
        IClient client = null;
        client = mType != null ? new StorageClient(serviceClass, serviceName, owner, type, scope, server, mType).getClient() : new StorageClient(serviceClass, serviceName, owner, type, scope, server).getClient();
        InputStream is = null;
        is = client.get().RFileAStream(location);
        return is;
    }

    private String extractLocation(String url) {
        Object location = null;
        String[] loc = url.split("//");
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("url extracted: " + loc[1]);
        }
        return loc[1];
    }

    private void createFileTest(InputStream is) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File("/home/rcirillo/FilePerTest/uriSMPTest.jpg"));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            is.close();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("New file created!");
        }
    }
}

