/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.BsonWriterHelper;
import com.mongodb.connection.LevelCountingBsonWriter;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.SplittablePayload;
import org.bson.BsonWriter;
import org.bson.io.BsonOutput;

class SplittablePayloadBsonWriter
extends LevelCountingBsonWriter {
    private final BsonWriter writer;
    private final BsonOutput bsonOutput;
    private final SplittablePayload payload;
    private final MessageSettings settings;
    private int commandStartPosition;

    SplittablePayloadBsonWriter(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, SplittablePayload payload) {
        super(writer);
        this.writer = writer;
        this.bsonOutput = bsonOutput;
        this.settings = settings;
        this.payload = payload;
    }

    @Override
    public void writeStartDocument() {
        super.writeStartDocument();
        if (this.getCurrentLevel() == 0) {
            this.commandStartPosition = this.bsonOutput.getPosition();
        }
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0 && this.payload.getPayload().size() > 0) {
            BsonWriterHelper.writePayloadArray(this.writer, this.bsonOutput, this.settings, this.commandStartPosition, this.payload);
        }
        super.writeEndDocument();
    }
}

