/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

final class MapCodec<T>
implements Codec<Map<String, T>> {
    private final Class<Map<String, T>> encoderClass;
    private final Codec<T> codec;

    MapCodec(Class<Map<String, T>> encoderClass, Codec<T> codec) {
        this.encoderClass = encoderClass;
        this.codec = codec;
    }

    @Override
    public void encode(BsonWriter writer, Map<String, T> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            this.codec.encode(writer, entry.getValue(), encoderContext);
        }
        writer.writeEndDocument();
    }

    @Override
    public Map<String, T> decode(BsonReader reader, DecoderContext context) {
        reader.readStartDocument();
        Map<String, T> map = this.getInstance();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            map.put(reader.readName(), this.codec.decode(reader, context));
        }
        reader.readEndDocument();
        return map;
    }

    @Override
    public Class<Map<String, T>> getEncoderClass() {
        return this.encoderClass;
    }

    private Map<String, T> getInstance() {
        try {
            return this.encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }
}

