/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.icclient;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.icclient.Helper;
import org.gcube.resources.discovery.icclient.stubs.CollectorConstants;
import org.gcube.resources.discovery.icclient.stubs.CollectorStub;
import org.gcube.resources.discovery.icclient.stubs.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICClient
implements DiscoveryClient<String> {
    private static final Logger log = LoggerFactory.getLogger(ICClient.class);
    private static final Pattern pattern = Pattern.compile("<Record>(.*?)</Record>", 32);

    @Override
    public List<String> submit(Query query) throws DiscoveryException {
        try {
            CollectorStub stub = this.getStub();
            String results = this.callService(query, stub);
            return this.splitIntoList(results);
        }
        catch (MalformedQueryException e) {
            throw new DiscoveryException("malformed query " + query.expression(), e);
        }
        catch (SOAPFaultException e) {
            throw new RuntimeException(JAXWSUtils.remoteCause(e));
        }
    }

    private String callService(Query query, CollectorStub stub) {
        String expression = query.expression();
        log.info("executing query {}", (Object)expression);
        long time = System.currentTimeMillis();
        String submittedExpression = Helper.queryAddAuthenticationControl(expression);
        String response = stub.execute(submittedExpression);
        log.info("executed query {} in {} ms", (Object)expression, (Object)(System.currentTimeMillis() - time));
        return response;
    }

    private CollectorStub getStub() {
        String address = ServiceMap.instance.endpoint("XQueryAccessService");
        log.info("connectinfg to " + address);
        return StubFactory.stubFor(CollectorConstants.collector).at(URI.create(address));
    }

    private List<String> splitIntoList(String response) {
        ArrayList<String> results = new ArrayList<String>();
        Matcher m = pattern.matcher(response);
        while (m.find()) {
            results.add(m.group(1).trim());
        }
        return results;
    }
}

