/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.Statement;

public abstract class AbstractN1qlQuery
extends N1qlQuery {
    private N1qlParams queryParameters;
    private SerializableStatement statement;

    protected abstract String statementType();

    protected abstract Object statementValue();

    protected abstract JsonValue statementParameters();

    protected AbstractN1qlQuery(Statement statement, N1qlParams params) {
        this.statement = statement instanceof SerializableStatement ? (SerializableStatement)statement : new N1qlQuery.RawStatement(statement.toString());
        this.queryParameters = params == null ? N1qlParams.build() : params;
    }

    @Override
    public N1qlParams params() {
        return this.queryParameters;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public JsonObject n1ql() {
        JsonObject query = JsonObject.create().put(this.statementType(), this.statementValue());
        AbstractN1qlQuery.populateParameters(query, this.statementParameters());
        this.queryParameters.injectParams(query);
        return query;
    }

    public static void populateParameters(JsonObject query, JsonValue params) {
        if (params instanceof JsonArray && !((JsonArray)params).isEmpty()) {
            query.put("args", (JsonArray)params);
        } else if (params instanceof JsonObject && !((JsonObject)params).isEmpty()) {
            JsonObject namedParams = (JsonObject)params;
            for (String key : namedParams.getNames()) {
                Object value = namedParams.get(key);
                if (key.charAt(0) != '$') {
                    query.put('$' + key, value);
                    continue;
                }
                query.put(key, value);
            }
        }
    }
}

