/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.List;

public class ViewLocator
implements Locator {
    private static final ServiceNotAvailableException NOT_AVAILABLE = new ServiceNotAvailableException("Views are not available on this bucket type.");
    private long counter = 0L;

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        Node node;
        int offset;
        int i;
        BucketConfig bucketConfig = config.bucketConfig(request.bucket());
        if (!(bucketConfig instanceof CouchbaseBucketConfig)) {
            request.observable().onError(NOT_AVAILABLE);
            return;
        }
        int nodeSize = nodes.size();
        for (i = offset = (int)this.counter++ % nodeSize; i < nodeSize; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node, (CouchbaseBucketConfig)bucketConfig)) continue;
            node.send(request);
            return;
        }
        for (i = 0; i < offset; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node, (CouchbaseBucketConfig)bucketConfig)) continue;
            node.send(request);
            return;
        }
        RetryHelper.retryOrCancel(env, request, responseBuffer);
    }

    protected boolean checkNode(Node node, CouchbaseBucketConfig config) {
        return node.serviceEnabled(ServiceType.VIEW) && config.hasPrimaryPartitionsOnNode(node.hostname());
    }
}

