/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.accounting;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAccountingImpl
implements Report {
    final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
    public StorageUsageRecord sur;
    public AccountingPersistence accountingPersistence;

    @Override
    public void init() {
        this.accountingPersistence = AccountingPersistenceFactory.getPersistence();
        try {
            this.sur = new StorageUsageRecord();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public StorageUsageRecord setGenericProperties(String resourceType, String consumerId, String resourceScope, String creationTime, String lastAccess, String owner, String operation, String size) {
        this.logger.trace("set accounting generic properties:  operation: " + operation + " resourceType: " + resourceType + " consumerId " + consumerId + " scope: " + resourceScope + " creationTime " + creationTime + " lastAccess " + lastAccess + " owner " + owner);
        if (this.accountingPersistence == null) {
            this.init();
        }
        if (this.sur == null) {
            this.sur = new StorageUsageRecord();
        }
        try {
            this.sur.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            this.sur.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            if (consumerId != null) {
                this.sur.setConsumerId(consumerId);
            }
            if (resourceScope != null) {
                this.sur.setResourceScope(resourceScope);
            }
            if (owner != null) {
                this.sur.setResourceOwner(owner);
            }
            if (operation != null) {
                AbstractStorageUsageRecord.OperationType accountingOperation = this.convertOperation(operation);
                this.logger.debug("operation converted: " + accountingOperation);
                this.sur.setOperationType(accountingOperation);
            }
            if (size != null) {
                this.sur.setDataVolume(Long.parseLong(size));
            }
            this.sur.setResourceURI(new URI("NOT_PROVIDED"));
            this.sur.setProviderURI(new URI("NOT_PROVIDED"));
        }
        catch (InvalidValueException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.logger.debug("generic fields completed ");
        return this.sur;
    }

    @Override
    public StorageUsageRecord setSpecificProperties(StorageUsageRecord sur, String filePath, String dataType, String callerIP, String id) {
        this.logger.trace("set accounting properties:  remotePath: " + filePath + " dataType " + dataType + " callerIP " + callerIP);
        if (sur == null) {
            sur = new StorageUsageRecord();
        }
        try {
            if (filePath != null) {
                sur.setResourceProperty("remotePath", (Serializable)((Object)filePath));
            }
            if (callerIP != null) {
                sur.setResourceProperty("callerIP", (Serializable)((Object)callerIP));
            }
            if (id != null) {
                sur.setResourceProperty("id", (Serializable)((Object)id));
            }
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        return sur;
    }

    private AbstractStorageUsageRecord.OperationType convertOperation(String operation) {
        this.logger.debug("converting operation: " + operation);
        switch (operation) {
            case "UPLOAD": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DELETE": {
                return AbstractStorageUsageRecord.OperationType.DELETE;
            }
            case "MOVE": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "MOVE_DIR": {
                return AbstractStorageUsageRecord.OperationType.UPDATE;
            }
            case "COPY_DIR": {
                return AbstractStorageUsageRecord.OperationType.CREATE;
            }
            case "DOWNLOAD": {
                return AbstractStorageUsageRecord.OperationType.READ;
            }
        }
        throw new RuntimeException("The operation " + operation + " is not converted or supported");
    }

    @Override
    public void printRecord(StorageUsageRecord record) {
        this.logger.info(" accounting properties: \n\t owner: " + record.getResourceOwner() + "\n\t scope " + record.getResourceScope() + "\n\t type " + record.getOperationType() + "\n\t consumer  " + record.getConsumerId() + "\n\t file  " + record.getResourceProperty("remotePath") + "\n\t size  " + record.getDataVolume() + "\n\t caller  " + record.getResourceProperty("callerIP") + "\n\t id  " + record.getResourceProperty("id") + "\n\t operation " + record.getOperationType());
    }

    @Override
    public void send(StorageUsageRecord sur) {
        this.accountingPersistence = AccountingPersistenceFactory.getPersistence();
        if (this.accountingPersistence != null) {
            this.logger.debug("report sending...");
            try {
                this.accountingPersistence.account((SingleUsageRecord)sur);
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            this.logger.info(" report send:  \n\t" + sur);
        } else {
            this.logger.error("Problem on building accounting record: Factory Object is null ");
        }
    }
}

