/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.accounting;

import org.gcube.contentmanager.storageserver.accounting.Report;
import org.gcube.contentmanager.storageserver.accounting.ReportAccountingImpl;
import org.gcube.contentmanager.storageserver.accounting.ReportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportFactory {
    static final Logger logger = LoggerFactory.getLogger(ReportFactory.class);

    public static Report getReport(int ReportType) throws ReportException {
        ReportAccountingImpl report = null;
        try {
            switch (ReportType) {
                case 1: {
                    report = new ReportAccountingImpl();
                    break;
                }
                default: {
                    throw new ReportException("MyDAOFactory.getDAO: [" + ReportType + "] is an UNKNOWN TYPE !");
                }
            }
            logger.trace("ReportFactory.getDao : returning class [" + report.getClass().getName() + "]...");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReportException("ReportFactory.getReport: Exception while getting Report type : \n" + e.getMessage());
        }
        logger.trace("MyReportFactory.getReport : returning class [" + report.getClass().getName() + "]...");
        return report;
    }
}

